/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.login;

import java.lang.reflect.InvocationTargetException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.NXCommon;
import org.netxms.base.VersionInfo;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.TwoFactorAuthenticationCallback;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.login.KeepAliveTimer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.services.LoginListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoginJob
implements IRunnableWithProgress {
    private I18n i18n = LocalizationHelper.getI18n(LoginJob.class);
    private Logger logger = LoggerFactory.getLogger(LoginJob.class);
    private Display display;
    private String server;
    private String loginName;
    private boolean enableCompression;
    private boolean ignoreProtocolVersion;
    private AuthenticationType authMethod;
    private String password;
    private Certificate certificate;
    private Signature signature;
    private String clientAddress;

    public LoginJob(Display display, boolean ignoreProtocolVersion, boolean enableCompression) {
        this.display = display;
        PreferenceStore settings = PreferenceStore.getInstance((Display)display);
        this.server = settings.getAsString("Connect.Server");
        this.loginName = settings.getAsString("Connect.Login");
        this.enableCompression = enableCompression;
        this.ignoreProtocolVersion = ignoreProtocolVersion;
        this.authMethod = AuthenticationType.PASSWORD;
        this.clientAddress = Registry.getClientAddress();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String hostName;
        monitor.beginTask(this.i18n.tr("Connecting..."), 9);
        int port = 4701;
        String[] split = this.server.split(":");
        if (split.length == 2) {
            hostName = split[0];
            try {
                port = Integer.valueOf(split[1]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            hostName = this.server;
        }
        this.logger.info("Connecting to " + hostName + " port " + port);
        NXCSession session = this.createSession(hostName, port);
        try {
            block15: {
                block14: {
                    session.setClientLanguage(Locale.getDefault().getLanguage());
                    session.setClientInfo("nxmc/" + VersionInfo.version());
                    session.setClientType(1);
                    session.setClientAddress(this.clientAddress);
                    session.setIgnoreProtocolVersion(this.ignoreProtocolVersion);
                    monitor.worked(1);
                    session.connect(new int[]{5});
                    monitor.worked(1);
                    session.login(this.authMethod, this.loginName, this.password, this.certificate, this.signature, (TwoFactorAuthenticationCallback)new /* Unavailable Anonymous Inner Class!! */);
                    monitor.worked(1);
                    monitor.setTaskName(this.i18n.tr("Synchronizing objects..."));
                    PreferenceStore store = PreferenceStore.getInstance();
                    boolean fullySync = store.getAsBoolean("Connect.FullObjectSync", false);
                    session.syncObjects(fullySync);
                    session.syncAssetManagementSchema();
                    monitor.worked(1);
                    monitor.setTaskName(this.i18n.tr("Synchronizing image library..."));
                    ImageProvider imageProvider = ImageProvider.createInstance((Display)this.display, (NXCSession)session);
                    for (ObjectCategory c : session.getObjectCategories()) {
                        UUID imageId = c.getIcon();
                        if (imageId == null || imageId.equals(NXCommon.EMPTY_GUID)) continue;
                        imageProvider.preloadImageFromServer(imageId);
                    }
                    monitor.worked(1);
                    monitor.setTaskName(this.i18n.tr("Synchronizing user database..."));
                    session.subscribeToUserDBUpdates();
                    monitor.worked(1);
                    monitor.setTaskName(this.i18n.tr("Synchronizing events configuration..."));
                    try {
                        session.syncEventTemplates();
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 2) break block14;
                        throw e;
                    }
                }
                try {
                    session.syncAlarmCategories();
                }
                catch (NXCException e) {
                    if (e.getErrorCode() == 2) break block15;
                    throw e;
                }
            }
            monitor.worked(1);
            monitor.setTaskName(this.i18n.tr("Subscribing to notifications..."));
            session.subscribe("Core.Alarms");
            monitor.worked(1);
            Registry.setSession((Display)this.display, (NXCSession)session);
            this.callLoginListeners(session);
            monitor.worked(1);
            LoginJob.setupSessionListener((NXCSession)session, (Display)this.display);
            this.logger.info("Creating keepalive timer");
            new KeepAliveTimer(session).start();
        }
        catch (Exception e) {
            session.disconnect();
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.setTaskName("");
            monitor.done();
        }
        this.logger.info("Login job completed");
    }

    private static void setupSessionListener(NXCSession session, Display display) {
        session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private NXCSession createSession(String hostName, int port) {
        return new NXCSession(hostName, port, this.enableCompression);
    }

    private void callLoginListeners(NXCSession session) {
        ServiceLoader<LoginListener> loader = ServiceLoader.load(LoginListener.class, this.getClass().getClassLoader());
        for (LoginListener l : loader) {
            this.logger.debug("Calling login listener " + l.toString());
            try {
                l.afterLogin(session, this.display);
            }
            catch (Exception e) {
                this.logger.error("Exception in login listener", (Throwable)e);
            }
        }
    }

    public void setPassword(String password) {
        this.password = password;
        this.authMethod = AuthenticationType.PASSWORD;
    }

    public void setCertificate(Certificate certificate, Signature signature) {
        this.certificate = certificate;
        this.signature = signature;
        this.authMethod = AuthenticationType.CERTIFICATE;
    }

    public void setAuthByToken() {
        this.authMethod = AuthenticationType.TOKEN;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }
}

