/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.gef4.zest.core.widgets.ILabeledFigure;
import org.eclipse.gef4.zest.core.widgets.IStyleableFigure;
import org.eclipse.gef4.zest.core.widgets.InternalNodeLayout;
import org.eclipse.gef4.zest.core.widgets.internal.GraphLabel;
import org.eclipse.gef4.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GraphNode
extends GraphItem {
    public static final int HIGHLIGHT_NONE = 0;
    public static final int HIGHLIGHT_ON = 1;
    private int nodeStyle;
    private List sourceConnections;
    private List targetConnections;
    private Color foreColor;
    private Color backColor;
    private Color highlightColor;
    private Color borderColor;
    private Color borderHighlightColor;
    private int borderWidth;
    private PrecisionPoint currentLocation;
    protected Dimension size;
    private Font font;
    private boolean cacheLabel;
    private boolean visible = true;
    protected Graph graph;
    protected IContainer parent;
    protected Object internalNode;
    private boolean selected;
    protected int highlighted = 0;
    private IFigure tooltip;
    protected IFigure nodeFigure;
    private boolean isDisposed = false;
    private boolean hasCustomTooltip;
    static int count = 0;
    private IFigure fishEyeFigure = null;
    private boolean isFisheyeEnabled;
    private InternalNodeLayout layout;

    public GraphNode(IContainer graphModel, int style) {
        this(graphModel, style, (IFigure)null);
    }

    public GraphNode(IContainer graphModel, int style, String text) {
        this(graphModel, style, text, null, null);
    }

    public GraphNode(IContainer graphModel, int style, Object data) {
        this(graphModel, style, "", null, data);
    }

    public GraphNode(IContainer graphModel, int style, String text, Image image) {
        this(graphModel, style, text, image, null);
    }

    protected GraphNode(IContainer graphModel, int style, IFigure figure) {
        this(graphModel, style, "", null, figure);
    }

    private GraphNode(IContainer graphModel, int style, String text, Image image, Object data) {
        super(graphModel, style, data);
        this.initModel(graphModel, text, image);
        if (this.nodeFigure == null) {
            this.initFigure();
        }
        this.parent.addNode(this);
        this.parent.getGraph().registerItem(this);
    }

    protected void initFigure() {
        this.nodeFigure = this.createFigureForModel();
    }

    protected void initModel(IContainer graphModel, String text, Image image) {
        this.nodeStyle |= graphModel.getGraph().getNodeStyle();
        this.parent = graphModel;
        this.sourceConnections = new ArrayList();
        this.targetConnections = new ArrayList();
        this.foreColor = graphModel.getGraph().DARK_BLUE;
        this.backColor = graphModel.getGraph().LIGHT_BLUE;
        this.highlightColor = graphModel.getGraph().HIGHLIGHT_COLOR;
        this.borderColor = ColorConstants.lightGray;
        this.borderHighlightColor = ColorConstants.blue;
        this.borderWidth = 1;
        this.currentLocation = new PrecisionPoint(0, 0);
        this.size = new Dimension(-1, -1);
        this.font = Display.getDefault().getSystemFont();
        this.graph = graphModel.getGraph();
        this.cacheLabel = false;
        this.setText(text);
        if (image != null) {
            this.setImage(image);
        }
        if (this.font == null) {
            this.font = Display.getDefault().getSystemFont();
        }
    }

    public String toString() {
        return "GraphModelNode: " + this.getText();
    }

    @Override
    public void dispose() {
        GraphConnection connection;
        if (this.isFisheyeEnabled) {
            this.fishEye(false, false);
        }
        super.dispose();
        this.isDisposed = true;
        while (this.getSourceConnections().size() > 0) {
            connection = (GraphConnection)((Object)this.getSourceConnections().get(0));
            if (!connection.isDisposed()) {
                connection.dispose();
                continue;
            }
            this.removeSourceConnection(connection);
        }
        while (this.getTargetConnections().size() > 0) {
            connection = (GraphConnection)((Object)this.getTargetConnections().get(0));
            if (!connection.isDisposed()) {
                connection.dispose();
                continue;
            }
            this.removeTargetConnection(connection);
        }
        this.graph.removeNode(this);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public boolean isSizeFixed() {
        return this.size.width >= 0 || this.size.height >= 0;
    }

    public List getSourceConnections() {
        return new ArrayList(this.sourceConnections);
    }

    public List getTargetConnections() {
        return new ArrayList(this.targetConnections);
    }

    Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public Point getLocation() {
        return this.currentLocation;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setLocation(double x, double y) {
        if (this.currentLocation.preciseX() != x || this.currentLocation.preciseY() != y) {
            this.currentLocation.setPreciseX(x);
            this.currentLocation.setPreciseY(y);
            this.refreshBounds();
            if (this.getGraphModel().isDynamicLayoutEnabled()) {
                this.parent.getLayoutContext().fireNodeMovedEvent(this.getLayout());
            }
        }
    }

    public Dimension getSize() {
        if (this.size.height < 0 && this.size.width < 0 && this.nodeFigure != null) {
            return this.nodeFigure.getSize().getCopy();
        }
        return this.size.getCopy();
    }

    public Color getForegroundColor() {
        return this.foreColor;
    }

    public void setForegroundColor(Color c) {
        this.foreColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setBackgroundColor(Color c) {
        this.backColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setTooltip(IFigure tooltip) {
        this.hasCustomTooltip = true;
        this.tooltip = tooltip;
        this.updateFigureForModel(this.nodeFigure);
    }

    public IFigure getTooltip() {
        return this.tooltip;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setBorderHighlightColor(Color c) {
        this.borderHighlightColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
    }

    @Override
    public void highlight() {
        if (this.highlighted == 1) {
            return;
        }
        IFigure parentFigure = this.nodeFigure.getParent();
        if (parentFigure instanceof ZestRootLayer) {
            ((ZestRootLayer)parentFigure).highlightNode(this.nodeFigure);
        }
        this.highlighted = 1;
        this.updateFigureForModel(this.getNodeFigure());
    }

    @Override
    public void unhighlight() {
        if (this.highlighted == 0) {
            return;
        }
        IFigure parentFigure = this.nodeFigure.getParent();
        if (parentFigure instanceof ZestRootLayer) {
            ((ZestRootLayer)parentFigure).unHighlightNode(this.nodeFigure);
        }
        this.highlighted = 0;
        this.updateFigureForModel(this.nodeFigure);
    }

    void refreshBounds() {
        Rectangle fishEyeBounds;
        Point loc = this.getLocation();
        Dimension size = this.getSize();
        Rectangle bounds = new Rectangle(loc, size);
        if (this.nodeFigure == null || this.nodeFigure.getParent() == null) {
            return;
        }
        this.nodeFigure.getParent().setConstraint(this.nodeFigure, (Object)bounds);
        if (this.isFisheyeEnabled && (fishEyeBounds = this.calculateFishEyeBounds()) != null) {
            this.fishEyeFigure.getParent().translateToRelative((Translatable)fishEyeBounds);
            this.fishEyeFigure.getParent().translateFromParent((Translatable)fishEyeBounds);
            this.fishEyeFigure.getParent().setConstraint(this.fishEyeFigure, (Object)fishEyeBounds);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.updateFigureForModel(this.nodeFigure);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        super.setText(string);
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.updateFigureForModel(this.nodeFigure);
    }

    @Override
    public Graph getGraphModel() {
        return this.graph;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
        this.cacheLabel = (this.nodeStyle & 2) > 0;
    }

    public void setSize(double width, double height) {
        if (width != (double)this.size.width || height != (double)this.size.height) {
            this.size.width = (int)width;
            this.size.height = (int)height;
            this.refreshBounds();
        }
    }

    public Color getBorderHighlightColor() {
        return this.borderHighlightColor;
    }

    public boolean cacheLabel() {
        return this.cacheLabel;
    }

    public void setCacheLabel(boolean cacheLabel) {
        this.cacheLabel = cacheLabel;
    }

    IFigure getNodeFigure() {
        return this.nodeFigure;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.getFigure().setVisible(visible);
        for (GraphConnection connection : this.sourceConnections) {
            connection.setVisible(visible);
        }
        for (GraphConnection connection : this.targetConnections) {
            connection.setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public int getStyle() {
        return super.getStyle() | this.getNodeStyle();
    }

    protected IFigure fishEye(boolean enable, boolean animate) {
        if (this.isDisposed) {
            return null;
        }
        if (!this.checkStyle(4)) {
            return null;
        }
        if (enable) {
            this.fishEyeFigure = this.createFishEyeFigure();
            Rectangle rectangle = this.calculateFishEyeBounds();
            if (rectangle == null) {
                return null;
            }
            this.getGraphModel().fishEye(this.nodeFigure, this.fishEyeFigure, rectangle, animate);
            if (this.fishEyeFigure != null) {
                this.isFisheyeEnabled = true;
            }
            return this.fishEyeFigure;
        }
        this.isFisheyeEnabled = false;
        this.getGraphModel().removeFishEye(this.fishEyeFigure, this.nodeFigure, animate);
        return null;
    }

    IContainer getParent() {
        return this.parent;
    }

    boolean isHighlighted() {
        return this.highlighted > 0;
    }

    protected void updateFigureForModel(IFigure currentFigure) {
        IFigure newFisheyeFigure;
        IFigure toolTip;
        if (currentFigure == null) {
            return;
        }
        IFigure figure = currentFigure;
        if (figure instanceof ILabeledFigure) {
            ILabeledFigure labeledFigure = (ILabeledFigure)figure;
            if (!this.checkStyle(8) && !labeledFigure.getText().equals(this.getText())) {
                labeledFigure.setText(this.getText());
            }
            if (labeledFigure.getIcon() != this.getImage()) {
                labeledFigure.setIcon(this.getImage());
            }
        }
        if (figure instanceof IStyleableFigure) {
            IStyleableFigure styleableFigure = (IStyleableFigure)figure;
            if (this.highlighted == 1) {
                styleableFigure.setForegroundColor(this.getForegroundColor());
                styleableFigure.setBackgroundColor(this.getHighlightColor());
                styleableFigure.setBorderColor(this.getBorderHighlightColor());
            } else {
                styleableFigure.setForegroundColor(this.getForegroundColor());
                styleableFigure.setBackgroundColor(this.getBackgroundColor());
                styleableFigure.setBorderColor(this.getBorderColor());
            }
            styleableFigure.setBorderWidth(this.getBorderWidth());
            if (figure.getFont() != this.getFont()) {
                figure.setFont(this.getFont());
            }
        }
        if (this.getTooltip() == null && !this.hasCustomTooltip) {
            toolTip = new Label();
            ((Label)toolTip).setText(this.getText());
        } else {
            toolTip = this.getTooltip();
        }
        figure.setToolTip(toolTip);
        if (this.isFisheyeEnabled && this.graph.replaceFishFigure(this.fishEyeFigure, newFisheyeFigure = this.createFishEyeFigure())) {
            this.fishEyeFigure = newFisheyeFigure;
        }
        this.refreshBounds();
    }

    protected IFigure createFigureForModel() {
        GraphNode node = this;
        boolean cacheLabel = this.cacheLabel();
        GraphLabel label = new GraphLabel(node.getText(), node.getImage(), cacheLabel);
        label.setFont(this.font);
        if (this.checkStyle(8)) {
            label.setText("");
        }
        this.updateFigureForModel(label);
        label.addFigureListener(new FigureListener(label){
            private Dimension previousSize;
            {
                this.previousSize = graphLabel.getBounds().getSize();
            }

            public void figureMoved(IFigure source) {
                if (Animation.isAnimating() || GraphNode.this.getLayout().isMinimized()) {
                    return;
                }
                Rectangle newBounds = GraphNode.this.nodeFigure.getBounds();
                if (!newBounds.getSize().equals((Object)this.previousSize)) {
                    this.previousSize = newBounds.getSize();
                    if (GraphNode.this.size.width >= 0 && GraphNode.this.size.height >= 0) {
                        GraphNode.this.size = newBounds.getSize();
                    }
                    GraphNode.this.currentLocation = new PrecisionPoint(GraphNode.this.nodeFigure.getBounds().getTopLeft());
                    GraphNode.this.parent.getLayoutContext().fireNodeResizedEvent(GraphNode.this.getLayout());
                } else if (GraphNode.this.currentLocation.x != newBounds.x || GraphNode.this.currentLocation.y != newBounds.y) {
                    GraphNode.this.currentLocation = new PrecisionPoint(GraphNode.this.nodeFigure.getBounds().getTopLeft());
                    GraphNode.this.parent.getLayoutContext().fireNodeMovedEvent(GraphNode.this.getLayout());
                }
            }
        });
        return label;
    }

    private IFigure createFishEyeFigure() {
        GraphNode node = this;
        boolean cacheLabel = this.cacheLabel();
        GraphLabel label = new GraphLabel(node.getText(), node.getImage(), cacheLabel);
        if (this.highlighted == 1) {
            label.setForegroundColor(this.getForegroundColor());
            label.setBackgroundColor(this.getHighlightColor());
            label.setBorderColor(this.getBorderHighlightColor());
        } else {
            label.setForegroundColor(this.getForegroundColor());
            label.setBackgroundColor(this.getBackgroundColor());
            label.setBorderColor(this.getBorderColor());
        }
        label.setBorderWidth(this.getBorderWidth());
        label.setFont(this.getFont());
        return label;
    }

    private Rectangle calculateFishEyeBounds() {
        Rectangle rectangle = this.nodeFigure.getBounds().getCopy();
        Dimension newSize = this.fishEyeFigure.getPreferredSize();
        Rectangle currentSize = rectangle.getCopy();
        this.nodeFigure.translateToAbsolute((Translatable)currentSize);
        int expandedH = Math.max((newSize.height - currentSize.height) / 2 + 1, 0);
        int expandedW = Math.max((newSize.width - currentSize.width) / 2 + 1, 0);
        Dimension expandAmount = new Dimension(expandedW, expandedH);
        this.nodeFigure.translateToAbsolute((Translatable)rectangle);
        rectangle.expand(new Insets(expandAmount.height, expandAmount.width, expandAmount.height, expandAmount.width));
        if (expandedH <= 0 && expandedW <= 0) {
            return null;
        }
        return rectangle;
    }

    void addSourceConnection(GraphConnection connection) {
        this.sourceConnections.add(connection);
    }

    void addTargetConnection(GraphConnection connection) {
        this.targetConnections.add(connection);
    }

    void removeSourceConnection(GraphConnection connection) {
        this.sourceConnections.remove((Object)connection);
    }

    void removeTargetConnection(GraphConnection connection) {
        this.targetConnections.remove((Object)connection);
    }

    void setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return;
        }
        if (selected) {
            this.highlight();
        } else {
            this.unhighlight();
        }
        this.selected = selected;
    }

    @Override
    public int getItemType() {
        return 1;
    }

    @Override
    public IFigure getFigure() {
        if (this.nodeFigure == null) {
            this.initFigure();
        }
        return this.getNodeFigure();
    }

    public InternalNodeLayout getLayout() {
        if (this.layout == null) {
            this.layout = new InternalNodeLayout(this);
        }
        return this.layout;
    }

    void applyLayoutChanges() {
        if (this.layout != null) {
            this.layout.applyLayout();
        }
    }
}

