/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.log.LogColumn;

public class LogRecordDetails {
    private long id;
    private List<LogColumn> columns;
    private List<String> values;

    protected LogRecordDetails(long id, NXCPMessage msg) {
        this.id = id;
        int count = msg.getFieldAsInt32(166L);
        this.columns = new ArrayList<LogColumn>(count);
        this.values = new ArrayList<String>(count);
        long fieldIdMetadata = 0x10000000L;
        long fieldIdData = 0x20000000L;
        int i = 0;
        while (i < count) {
            this.columns.add(new LogColumn(msg, fieldIdMetadata));
            this.values.add(msg.getFieldAsString(fieldIdData++));
            ++i;
            fieldIdMetadata += 10L;
        }
    }

    public long getId() {
        return this.id;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<LogColumn> getColumnDefinitions() {
        return this.columns;
    }

    public int getColumnIndex(String name) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i).getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public String getValue(String columnName) {
        int index = this.getColumnIndex(columnName);
        return index >= 0 ? this.values.get(index) : null;
    }

    public long getValueAsLong(int index) {
        String s = this.values.get(index);
        if (s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public long getValueAsLong(String columnName) {
        int index = this.getColumnIndex(columnName);
        return index >= 0 ? this.getValueAsLong(index) : 0L;
    }

    public String toString() {
        return "LogRecordDetails [id=" + this.id + ", columns=" + this.columns + ", values=" + this.values + "]";
    }
}

