/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import io.nayuki.qrcodegen.QrCode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class QRLabel
extends Canvas {
    private String text = "";

    public QRLabel(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                QRLabel.this.drawQRCode(e.gc);
            }
        });
    }

    private void drawQRCode(GC gc) {
        Rectangle rect = this.getClientArea();
        int offsetWidth = 0;
        int offsetHeight = 0;
        if (rect.width > rect.height) {
            offsetWidth = (rect.width - rect.height) / 2;
            rect.width = rect.height;
        } else if (rect.width < rect.height) {
            offsetHeight = (rect.height - rect.width) / 2;
            rect.height = rect.width;
        }
        QrCode qr = QrCode.encodeText((String)this.text, (QrCode.Ecc)QrCode.Ecc.MEDIUM);
        float scale = (float)rect.width / (float)qr.size;
        int y = 0;
        while (y < rect.height) {
            int x = 0;
            while (x < rect.width) {
                if (qr.getModule((int)((float)x / scale), (int)((float)y / scale))) {
                    gc.drawPoint(x + offsetWidth, y + offsetHeight);
                }
                ++x;
            }
            ++y;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }
}

