/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.ResponseContainer;

public class LastValues
extends AbstractObjectHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        AbstractObject object = this.getObject();
        ArrayList<DciValue[]> values = new ArrayList<DciValue[]>();
        if (object instanceof DataCollectionTarget) {
            values.add(session.getLastValues(object.getObjectId()));
        } else {
            AbstractObject[] children;
            for (AbstractObject child : children = object.getChildrenAsArray()) {
                if (!(child instanceof DataCollectionTarget)) continue;
                values.add(session.getLastValues(child.getObjectId()));
            }
        }
        String dciName = query.containsKey("dciName") ? query.get("dciName").toUpperCase() : null;
        String dciNameRegexp = query.get("dciNameRegexp");
        String dciDescription = query.containsKey("dciDescription") ? query.get("dciDescription").toUpperCase() : null;
        String dciDescriptionRegexp = query.get("dciDescriptionRegexp");
        Pattern nameRegex = null;
        if (dciNameRegexp != null && !dciNameRegexp.isEmpty()) {
            nameRegex = Pattern.compile(dciNameRegexp, 2);
        }
        Pattern descriptionRegex = null;
        if (dciDescriptionRegexp != null && !dciDescriptionRegexp.isEmpty()) {
            descriptionRegex = Pattern.compile(dciDescriptionRegexp, 2);
        }
        if (dciName != null || dciNameRegexp != null || dciDescription != null || dciDescriptionRegexp != null) {
            ArrayList<DciValue[]> newValues = new ArrayList<DciValue[]>();
            for (DciValue[] valArray : values) {
                ArrayList<DciValue> tmp = new ArrayList<DciValue>();
                for (DciValue v : valArray) {
                    if (!(dciName != null && v.getName().toUpperCase().contains(dciName) || nameRegex != null && nameRegex.matcher(v.getName()).matches() || dciDescription != null && v.getDescription().toUpperCase().contains(dciDescription)) && (descriptionRegex == null || !descriptionRegex.matcher(v.getDescription()).matches())) continue;
                    tmp.add(v);
                }
                if (tmp.isEmpty()) continue;
                newValues.add(tmp.toArray(new DciValue[tmp.size()]));
            }
            values = newValues;
        }
        return new ResponseContainer("lastValues", (Object)values.toArray());
    }
}

