/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.base.Glob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.JsonTools;
import org.netxms.websvc.json.ResponseContainer;

/*
 * Exception performing whole class analysis ignored.
 */
public class Alarms
extends AbstractHandler {
    private static final int UNDEFINED = -1;
    private static final int TERMINATE = 0;
    private static final int ACKNOWLEDGE = 1;
    private static final int STICKY_ACKNOWLEDGE = 2;
    private static final int RESOLVE = 3;

    protected Object getCollection(Map<String, String> query) throws Exception {
        boolean[] stateMask;
        NXCSession session = this.getSession();
        Collection alarms = session.getAlarms().values();
        AbstractObject rootObject = this.getObjectFromQuery(query);
        String stateFilter = query.get("state");
        if (stateFilter != null) {
            stateMask = new boolean[]{false, false, false, false};
            for (String s : stateFilter.split(",")) {
                try {
                    int n = Integer.parseInt(s);
                    if (n < 0 || n > 3) continue;
                    stateMask[n] = true;
                }
                catch (NumberFormatException e) {
                    if (s.equalsIgnoreCase("outstanding")) {
                        stateMask[0] = true;
                        continue;
                    }
                    if (s.equalsIgnoreCase("acknowledged")) {
                        stateMask[1] = true;
                        continue;
                    }
                    if (s.equalsIgnoreCase("resolved")) {
                        stateMask[2] = true;
                        continue;
                    }
                    if (!s.equalsIgnoreCase("terminated")) continue;
                    stateMask[3] = true;
                }
            }
        } else {
            stateMask = new boolean[]{true, true, true, true};
        }
        Date createdBefore = Alarms.parseTimestamp((String)query.get("createdBefore"));
        Date createdAfter = Alarms.parseTimestamp((String)query.get("createdAfter"));
        Date updatedBefore = Alarms.parseTimestamp((String)query.get("updatedBefore"));
        Date updatedAfter = Alarms.parseTimestamp((String)query.get("updatedAfter"));
        String keyFilter = query.get("key");
        String keyRegexFilter = query.get("keyRegex");
        String messageFilter = query.get("message");
        if (rootObject != null || stateFilter != null || createdBefore != null || createdAfter != null || updatedBefore != null || updatedAfter != null || keyFilter != null || keyRegexFilter != null || messageFilter != null) {
            boolean includeChildren = Boolean.parseBoolean(query.getOrDefault("includeChildObjects", "false"));
            Pattern keyPattern = keyRegexFilter != null ? Pattern.compile(keyRegexFilter, 2) : null;
            Pattern messagePattern = messageFilter != null ? Pattern.compile(messageFilter, 2) : null;
            Iterator iterator = alarms.iterator();
            while (iterator.hasNext()) {
                Alarm alarm = (Alarm)iterator.next();
                if (!stateMask[alarm.getState() & 0xF]) {
                    iterator.remove();
                    continue;
                }
                if (createdBefore != null && alarm.getCreationTime().after(createdBefore) || createdAfter != null && alarm.getCreationTime().before(createdAfter) || updatedBefore != null && alarm.getLastChangeTime().after(updatedBefore) || updatedAfter != null && alarm.getLastChangeTime().before(updatedAfter)) {
                    iterator.remove();
                    continue;
                }
                if (!(rootObject == null || alarm.getSourceObjectId() == rootObject.getObjectId() || includeChildren && rootObject.isParentOf(alarm.getSourceObjectId()))) {
                    iterator.remove();
                }
                if (keyFilter != null && alarm.getKey() != null && !Glob.matchIgnoreCase((String)keyFilter, (String)alarm.getKey())) {
                    iterator.remove();
                }
                if (keyPattern != null && alarm.getKey() != null && !keyPattern.matcher(alarm.getKey()).matches()) {
                    iterator.remove();
                }
                if (messagePattern == null || messagePattern.matcher(alarm.getMessage()).matches()) continue;
                iterator.remove();
            }
        }
        if (!Boolean.parseBoolean(query.getOrDefault("resolveReferences", "false")) || alarms.isEmpty()) {
            return new ResponseContainer("alarms", alarms);
        }
        if (!session.areObjectsSynchronized()) {
            session.syncObjects();
        }
        if (!session.isUserDatabaseSynchronized()) {
            this.executeIfAllowed(() -> session.syncUserDatabase());
        }
        if (!session.isAlarmCategoriesSynchronized()) {
            this.executeIfAllowed(() -> session.syncAlarmCategories());
        }
        if (!session.isEventObjectsSynchronized()) {
            this.executeIfAllowed(() -> session.syncEventTemplates());
        }
        ArrayList<JsonObject> serializedAlarms = new ArrayList<JsonObject>();
        HashMap<Long, DciValue[]> cachedValues = null;
        Gson gson = JsonTools.createGsonInstance();
        for (Alarm a : alarms) {
            JsonObject json = (JsonObject)gson.toJsonTree((Object)a);
            AbstractObject object = session.findObjectById(a.getSourceObjectId());
            if (object != null) {
                json.add("sourceObject", gson.toJsonTree((Object)object));
                if (a.getDciId() != 0L) {
                    DciValue[] values = null;
                    if (cachedValues != null) {
                        values = (DciValue[])cachedValues.get(object.getObjectId());
                    }
                    if (values == null) {
                        values = session.getLastValues(object.getObjectId());
                    }
                    for (DciValue v : values) {
                        if (v.getId() != a.getDciId()) continue;
                        json.add("dci", gson.toJsonTree((Object)v));
                        break;
                    }
                    if (cachedValues == null) {
                        cachedValues = new HashMap<Long, DciValue[]>();
                    }
                    cachedValues.put(object.getObjectId(), values);
                }
                if (session.isZoningEnabled() && object instanceof Node) {
                    json.addProperty("zoneUIN", (Number)((Node)object).getZoneId());
                    json.addProperty("zoneName", ((Node)object).getZoneName());
                }
            }
            Alarms.addUserName((JsonObject)json, (NXCSession)session, (int)a.getAcknowledgedByUser(), (String)"acknowledgedByUserName");
            Alarms.addUserName((JsonObject)json, (NXCSession)session, (int)a.getResolvedByUser(), (String)"resolvedByUserName");
            Alarms.addUserName((JsonObject)json, (NXCSession)session, (int)a.getTerminatedByUser(), (String)"terminatedByUserName");
            EventTemplate e = session.findEventTemplateByCode(a.getSourceEventCode());
            if (e != null) {
                json.addProperty("sourceEventName", e.getName());
            }
            json.remove("categories");
            JsonArray categories = new JsonArray();
            for (long cid : a.getCategories()) {
                JsonObject c = new JsonObject();
                c.addProperty("id", (Number)cid);
                AlarmCategory category = session.findAlarmCategoryById(cid);
                c.addProperty("name", category != null ? category.getName() : Long.toString(cid));
                categories.add((JsonElement)c);
            }
            json.add("categories", (JsonElement)categories);
            serializedAlarms.add(json);
        }
        return new ResponseContainer("alarms", serializedAlarms);
    }

    private static void addUserName(JsonObject json, NXCSession session, int userId, String property) {
        if (userId == 0) {
            return;
        }
        AbstractUserObject user = session.findUserDBObjectById(userId, null);
        if (user != null) {
            json.addProperty(property, user.getName());
        }
    }

    protected Object executeCommand(String command, JSONObject data) throws Exception {
        int action = -1;
        int timeout = 0;
        if (command.equals("terminate")) {
            action = 0;
        } else if (command.equals("acknowledge")) {
            action = 1;
        } else if (command.equals("sticky_acknowledge")) {
            action = 2;
            if (data.has("timeout")) {
                timeout = data.getInt("timeout");
            }
        } else if (command.equals("resolve")) {
            action = 3;
        }
        if (!data.has("alarms") || action == -1) {
            return this.createErrorResponse(12);
        }
        NXCSession session = this.getSession();
        JSONArray alarmList = data.getJSONArray("alarms");
        block6: for (int i = 0; i < alarmList.length(); ++i) {
            long alarmId = alarmList.getLong(i);
            switch (action) {
                case 0: {
                    session.terminateAlarm(alarmId);
                    continue block6;
                }
                case 1: {
                    session.acknowledgeAlarm(alarmId);
                    continue block6;
                }
                case 2: {
                    session.acknowledgeAlarm(alarmId, true, timeout);
                    continue block6;
                }
                case 3: {
                    session.resolveAlarm(alarmId);
                }
            }
        }
        return null;
    }

    protected Object get(String id, Map<String, String> query) throws Exception {
        Alarm alarm;
        NXCSession session = this.getSession();
        if (!session.areObjectsSynchronized()) {
            session.syncObjects();
        }
        if (!session.isUserDatabaseSynchronized()) {
            this.executeIfAllowed(() -> session.syncUserDatabase());
        }
        if (!session.isAlarmCategoriesSynchronized()) {
            this.executeIfAllowed(() -> session.syncAlarmCategories());
        }
        if (!session.isEventObjectsSynchronized()) {
            this.executeIfAllowed(() -> session.syncEventTemplates());
        }
        try {
            long alarmId = Long.parseLong(id);
            alarm = session.getAlarm(alarmId);
        }
        catch (NumberFormatException e) {
            throw new NXCException(21);
        }
        if (alarm == null) {
            throw new NXCException(21);
        }
        Gson gson = JsonTools.createGsonInstance();
        JsonObject json = (JsonObject)gson.toJsonTree((Object)alarm);
        AbstractObject object = session.findObjectById(alarm.getSourceObjectId());
        if (object != null) {
            json.add("sourceObject", gson.toJsonTree((Object)object));
            if (alarm.getDciId() != 0L) {
                DciValue[] values;
                for (DciValue v : values = session.getLastValues(object.getObjectId())) {
                    if (v.getId() != alarm.getDciId()) continue;
                    json.add("dci", gson.toJsonTree((Object)v));
                    break;
                }
            }
            if (session.isZoningEnabled() && object instanceof Node) {
                json.addProperty("zoneUIN", (Number)((Node)object).getZoneId());
                json.addProperty("zoneName", ((Node)object).getZoneName());
            }
        }
        Alarms.addUserName((JsonObject)json, (NXCSession)session, (int)alarm.getAcknowledgedByUser(), (String)"acknowledgedByUserName");
        Alarms.addUserName((JsonObject)json, (NXCSession)session, (int)alarm.getResolvedByUser(), (String)"resolvedByUserName");
        Alarms.addUserName((JsonObject)json, (NXCSession)session, (int)alarm.getTerminatedByUser(), (String)"terminatedByUserName");
        EventTemplate e = session.findEventTemplateByCode(alarm.getSourceEventCode());
        if (e != null) {
            json.addProperty("sourceEventName", e.getName());
        }
        json.remove("categories");
        JsonArray categories = new JsonArray();
        for (long cid : alarm.getCategories()) {
            JsonObject c = new JsonObject();
            c.addProperty("id", (Number)cid);
            AlarmCategory category = session.findAlarmCategoryById(cid);
            c.addProperty("name", category != null ? category.getName() : Long.toString(cid));
            categories.add((JsonElement)c);
        }
        json.add("categories", (JsonElement)categories);
        return json;
    }
}

