/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.json.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Date;

public class DateAdapter
extends TypeAdapter<Date> {
    public void write(JsonWriter writer, Date value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.value(value.getTime() / 1000L);
    }

    public Date read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        try {
            return new Date(reader.nextLong() * 1000L);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

