/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MapType {
    CUSTOM(0),
    LAYER2_TOPOLOGY(1),
    IP_TOPOLOGY(2),
    INTERNAL_TOPOLOGY(3),
    OSPF_TOPOLOGY(4),
    HYBRID_TOPOLOGY(5);

    private static Logger logger;
    private static Map<Integer, MapType> lookupTable;
    private int value;

    private MapType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MapType getByValue(int value) {
        MapType layout = lookupTable.get(value);
        if (layout == null) {
            logger.warn("Unknown layout alghoritm: " + value);
            return CUSTOM;
        }
        return layout;
    }

    static {
        logger = LoggerFactory.getLogger(MapType.class);
        lookupTable = new HashMap<Integer, MapType>();
        for (MapType element : MapType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

