/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RackOrientation {
    FILL(0),
    FRONT(1),
    REAR(2);

    private static Logger logger;
    private static Map<Integer, RackOrientation> lookupTable;
    private int value;

    private RackOrientation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackOrientation getByValue(int value) {
        RackOrientation element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return FILL;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(RackOrientation.class);
        lookupTable = new HashMap<Integer, RackOrientation>();
        for (RackOrientation element : RackOrientation.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

