/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.ConnectionPointType;

public class ConnectionPoint {
    private long localNodeId;
    private long localInterfaceId;
    private MacAddress localMacAddress;
    private InetAddress localIpAddress;
    private long nodeId;
    private long interfaceId;
    private int interfaceIndex;
    private ConnectionPointType type;
    private Object data;
    private boolean historical = false;

    public ConnectionPoint(NXCPMessage msg) {
        this.nodeId = msg.getFieldAsInt64(3L);
        this.interfaceId = msg.getFieldAsInt64(362L);
        this.interfaceIndex = msg.getFieldAsInt32(11L);
        this.localNodeId = msg.getFieldAsInt64(364L);
        this.localInterfaceId = msg.getFieldAsInt64(363L);
        this.localMacAddress = new MacAddress(msg.getFieldAsBinary(113L));
        this.localIpAddress = msg.getFieldAsInetAddress(8L);
        this.type = ConnectionPointType.getByValue(msg.getFieldAsInt32(418L));
    }

    public ConnectionPoint(NXCPMessage msg, long base2) {
        this.localMacAddress = new MacAddress(msg.getFieldAsBinary(base2));
        this.type = ConnectionPointType.getByValue(msg.getFieldAsInt32(base2 + 1L));
        this.nodeId = msg.getFieldAsInt64(base2 + 2L);
        this.interfaceId = msg.getFieldAsInt64(base2 + 3L);
        this.interfaceIndex = msg.getFieldAsInt32(base2 + 4L);
        this.localNodeId = msg.getFieldAsInt64(base2 + 5L);
        this.localInterfaceId = msg.getFieldAsInt64(base2 + 6L);
        this.localIpAddress = msg.getFieldAsInetAddress(base2 + 7L);
    }

    public ConnectionPoint(long localNodeId, long localInterfaceId) {
        this.localNodeId = localNodeId;
        this.localInterfaceId = localInterfaceId;
        this.type = ConnectionPointType.NOT_FOUND;
    }

    public ConnectionPoint(MacAddress macAddress) {
        this.type = ConnectionPointType.NOT_FOUND;
        this.localMacAddress = macAddress;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public long getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public void setInterfaceIndex(int interfaceIndex) {
        this.interfaceIndex = interfaceIndex;
    }

    public long getLocalNodeId() {
        return this.localNodeId;
    }

    public long getLocalInterfaceId() {
        return this.localInterfaceId;
    }

    public MacAddress getLocalMacAddress() {
        return this.localMacAddress;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public InetAddress getLocalIpAddress() {
        return this.localIpAddress;
    }

    public ConnectionPointType getType() {
        return this.type;
    }

    public boolean isHistorical() {
        return this.historical;
    }

    public void setHistorical(boolean historical) {
        this.historical = historical;
    }

    public String toString() {
        return "ConnectionPoint [localNodeId=" + this.localNodeId + ", localInterfaceId=" + this.localInterfaceId + ", localMacAddress=" + this.localMacAddress + ", localIpAddress=" + this.localIpAddress + ", nodeId=" + this.nodeId + ", interfaceId=" + this.interfaceId + ", interfaceIndex=" + this.interfaceIndex + ", type=" + this.type + ", data=" + this.data + "]";
    }
}

