/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.TextBoxConfig;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.xml.XMLTools;

public class NetworkMapTextBox
extends NetworkMapElement {
    private String text;
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private int fontSize;
    private long drillDownObjectId;
    private boolean borderRequired;

    protected NetworkMapTextBox(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String xmlConfig = msg.getFieldAsString(baseId + 10L);
        try {
            TextBoxConfig config2 = XMLTools.createFromXml(TextBoxConfig.class, xmlConfig);
            this.text = config2.getText();
            this.backgroundColor = config2.getBackgroundColor();
            this.textColor = config2.getTextColor();
            this.borderColor = config2.getBorderColor();
            this.borderRequired = config2.isBorderRequired();
            this.fontSize = config2.getFontSize();
            this.drillDownObjectId = config2.getDrillDownObjectId();
        }
        catch (Exception e) {
            this.text = "";
            this.backgroundColor = Integer.MAX_VALUE;
            this.textColor = 0;
            this.borderColor = 0;
            this.borderRequired = true;
            this.fontSize = 10;
            this.drillDownObjectId = 0L;
        }
        this.type = 5;
    }

    public NetworkMapTextBox(long id) {
        super(id);
        this.text = "";
        this.backgroundColor = Integer.MAX_VALUE;
        this.textColor = 0;
        this.borderColor = 0;
        this.borderRequired = true;
        this.fontSize = 10;
        this.type = 5;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        String xmlConfig;
        super.fillMessage(msg, baseId);
        TextBoxConfig config2 = new TextBoxConfig();
        config2.setText(this.text);
        config2.setBackgroundColor(this.backgroundColor);
        config2.setTextColor(this.textColor);
        config2.setBorderColor(this.borderColor);
        config2.setBorderRequired(this.borderRequired);
        config2.setFontSize(this.fontSize);
        config2.setDrillDownObjectId(this.drillDownObjectId);
        try {
            xmlConfig = config2.createXml();
        }
        catch (Exception e) {
            xmlConfig = "";
        }
        msg.setField(baseId + 10L, xmlConfig);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text2) {
        this.text = text2;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderRequired() {
        return this.borderRequired;
    }

    public void setBorderRequired(boolean borderRequired) {
        this.borderRequired = borderRequired;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public long getDrillDownObjectId() {
        return this.drillDownObjectId;
    }

    public void setDrillDownObjectId(long drillDownObjectId) {
        this.drillDownObjectId = drillDownObjectId;
    }
}

