/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.InputFieldType;

public class InputField {
    public static final int VALIDATE_PASSWORD = 1;
    private String name;
    private InputFieldType type;
    private String displayName;
    private int orderNumber;
    private int flags;

    public InputField(String name) {
        this.name = name;
        this.type = InputFieldType.TEXT;
        this.displayName = name;
        this.orderNumber = 0;
        this.flags = 0;
    }

    public InputField(String name, InputFieldType type, String displayName, int flags) {
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.orderNumber = 0;
        this.flags = flags;
    }

    public InputField(InputField src) {
        this.name = src.name;
        this.type = src.type;
        this.displayName = src.displayName;
        this.orderNumber = src.orderNumber;
        this.flags = src.flags;
    }

    public InputField(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.type = InputFieldType.getByValue(msg.getFieldAsInt32(baseId + 1L));
        this.displayName = msg.getFieldAsString(baseId + 2L);
        this.flags = msg.getFieldAsInt32(baseId + 3L);
        this.orderNumber = msg.getFieldAsInt32(baseId + 4L);
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.name);
        msg.setFieldInt16(baseId + 1L, this.type.getValue());
        msg.setField(baseId + 2L, this.displayName);
        msg.setFieldInt32(baseId + 3L, this.flags);
        msg.setFieldInt16(baseId + 4L, this.orderNumber);
    }

    public InputFieldType getType() {
        return this.type;
    }

    public void setType(InputFieldType type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isPasswordValidationNeeded() {
        return (this.flags & 1) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSequence() {
        return this.orderNumber;
    }

    public void setSequence(int sequence) {
        this.orderNumber = sequence;
    }

    public String toString() {
        return "InputField [name=" + this.name + ", type=" + this.type + ", displayName=" + this.displayName + ", orderNumber=" + this.orderNumber + ", flags=" + this.flags + "]";
    }
}

