/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class InetAddressEx {
    protected InetAddress address;
    protected int mask;

    public InetAddressEx(InetAddress address) {
        this.address = address;
        this.mask = address instanceof Inet4Address ? 32 : 128;
    }

    public InetAddressEx(InetAddress address, int mask) {
        this.address = address;
        this.mask = mask;
    }

    public InetAddressEx(InetAddress address, InetAddress mask) {
        this.address = address;
        this.mask = InetAddressEx.bitsInMask(mask);
    }

    public InetAddressEx(InetAddressEx src) {
        this.address = src.address;
        this.mask = src.mask;
    }

    public InetAddressEx() {
        this.address = null;
        this.mask = 0;
    }

    public boolean isValidAddress() {
        return this.address != null;
    }

    public boolean isValidUnicastAddress() {
        return this.address != null && !this.address.isAnyLocalAddress() && !this.address.isLinkLocalAddress() && !this.address.isLoopbackAddress() && !this.address.isMulticastAddress();
    }

    public String getHostAddress() {
        return this.address != null ? this.address.getHostAddress().replaceFirst("(^|:)(0+(:|$)){2,8}", "::") : "UNSPEC";
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getMask() {
        return this.mask;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public byte[] getAddressBytes() {
        return this.address != null ? this.address.getAddress() : new byte[]{};
    }

    public int getHostBits() {
        if (this.address instanceof Inet4Address) {
            return 32 - this.mask;
        }
        if (this.address instanceof Inet6Address) {
            return 128 - this.mask;
        }
        return 0;
    }

    public String toString() {
        return this.address != null ? this.address.getHostAddress().replaceFirst("(^|:)(0+(:|$)){2,8}", "::") + "/" + this.mask : "UNSPEC";
    }

    public static int bitsInMask(InetAddress mask) {
        byte[] bytes;
        int bits = 0;
        for (byte b : bytes = mask.getAddress()) {
            if (b == 255) {
                bits += 8;
                continue;
            }
            for (int m = 128; m != 0 && (b & m) == m; m >>= 1) {
                ++bits;
            }
        }
        return bits;
    }

    public InetAddress maskFromBits() {
        if (this.address == null) {
            return null;
        }
        try {
            int bits;
            byte[] bytes = new byte[this.address instanceof Inet4Address ? 4 : 16];
            int i = 0;
            for (bits = this.mask; bits > 8; bits -= 8) {
                bytes[i++] = -1;
            }
            int b = -128;
            while (bits-- > 0) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | b);
                b = (byte)(b >> 1);
            }
            return InetAddress.getByAddress(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.address == null ? 0 : this.address.hashCode());
        result2 = 31 * result2 + this.mask;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressEx other = (InetAddressEx)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.mask == other.mask;
    }
}

