/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.MapType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.MapOptions;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MapOptions
extends ObjectPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(MapOptions.class);
    private static final int FLAG_MASK = 1759;
    private NetworkMap map;
    private Button checkShowStatusIcon;
    private Button checkShowStatusFrame;
    private Button checkShowStatusBkgnd;
    private Button checkShowLinkDirection;
    private Button checkTranslucentLabelBkgnd;
    private Button checkUseL1Topology;
    private Button checkDontUpdateLinkText;
    private Combo objectDisplayMode;
    private Combo routingAlgorithm;
    private Button radioColorDefault;
    private Button radioColorCustom;
    private ColorSelector linkColor;
    private LabeledCombo comboLinkStyle;
    private LabeledSpinner spinerLineWidth;
    private Button checkIncludeEndNodes;
    private Button checkCustomRadius;
    private Spinner topologyRadius;
    private Button checkCalculateStatus;

    public MapOptions(AbstractObject object) {
        super(LocalizationHelper.getI18n(MapOptions.class).tr("Map Options"), object);
    }

    public String getId() {
        return "mapOptions";
    }

    public boolean isVisible() {
        return this.object instanceof NetworkMap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.map = (NetworkMap)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group objectDisplayGroup = new Group(dialogArea, 0);
        objectDisplayGroup.setText(this.i18n.tr("Default display options"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        objectDisplayGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        objectDisplayGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectDisplayMode = WidgetHelper.createLabeledCombo((Composite)objectDisplayGroup, (int)8, (String)this.i18n.tr("Display objects as"), (Object)gd);
        this.objectDisplayMode.add(this.i18n.tr("Icons"));
        this.objectDisplayMode.add(this.i18n.tr("Small labels"));
        this.objectDisplayMode.add(this.i18n.tr("Large labels"));
        this.objectDisplayMode.add(this.i18n.tr("Status icons"));
        this.objectDisplayMode.add(this.i18n.tr("Floor plan"));
        this.objectDisplayMode.select(this.map.getObjectDisplayMode().getValue());
        this.checkShowStatusIcon = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusIcon.setText(this.i18n.tr("Show status &icon"));
        this.checkShowStatusIcon.setSelection((this.map.getFlags() & 1) != 0);
        this.checkShowStatusFrame = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusFrame.setText(this.i18n.tr("Show status &frame"));
        this.checkShowStatusFrame.setSelection((this.map.getFlags() & 2) != 0);
        this.checkShowStatusBkgnd = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusBkgnd.setText(this.i18n.tr("Show status &background"));
        this.checkShowStatusBkgnd.setSelection((this.map.getFlags() & 4) != 0);
        this.checkShowLinkDirection = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowLinkDirection.setText("Show link direction");
        this.checkShowLinkDirection.setSelection((this.map.getFlags() & 0x40) != 0);
        this.checkTranslucentLabelBkgnd = new Button((Composite)objectDisplayGroup, 32);
        this.checkTranslucentLabelBkgnd.setText(this.i18n.tr("Translucent label background"));
        this.checkTranslucentLabelBkgnd.setSelection(this.map.isTranslucentLabelBackground());
        Group linkGroup = new Group(dialogArea, 0);
        linkGroup.setText(this.i18n.tr("Default connection options"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        linkGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        linkGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)linkGroup, (int)8, (String)this.i18n.tr("Routing algorithm"), (Object)gd);
        this.routingAlgorithm.add(this.i18n.tr("Direct"));
        this.routingAlgorithm.add(this.i18n.tr("Manhattan"));
        this.routingAlgorithm.select(this.map.getDefaultLinkRouting() - 1);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioColorDefault = new Button((Composite)linkGroup, 16);
        this.radioColorDefault.setText(this.i18n.tr("&Default color"));
        this.radioColorDefault.setSelection(this.map.getDefaultLinkColor() < 0);
        this.radioColorDefault.addSelectionListener((SelectionListener)listener);
        gd = new GridData();
        gd.verticalIndent = 8;
        this.radioColorDefault.setLayoutData((Object)gd);
        this.radioColorCustom = new Button((Composite)linkGroup, 16);
        this.radioColorCustom.setText(this.i18n.tr("&Custom color"));
        this.radioColorCustom.setSelection(this.map.getDefaultLinkColor() >= 0);
        this.radioColorCustom.addSelectionListener((SelectionListener)listener);
        this.linkColor = new ColorSelector((Composite)linkGroup);
        this.linkColor.setColorValue(ColorConverter.rgbFromInt((int)this.map.getDefaultLinkColor()));
        this.linkColor.setEnabled(this.map.getDefaultLinkColor() >= 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.linkColor.getButton().setLayoutData((Object)gd);
        this.comboLinkStyle = new LabeledCombo((Composite)linkGroup, 0);
        this.comboLinkStyle.setLabel(this.i18n.tr("Line style"));
        this.comboLinkStyle.add(this.i18n.tr("Solid"));
        this.comboLinkStyle.add(this.i18n.tr("Dash"));
        this.comboLinkStyle.add(this.i18n.tr("Dot"));
        this.comboLinkStyle.add(this.i18n.tr("Dashdot"));
        this.comboLinkStyle.add(this.i18n.tr("Dashdotdot"));
        this.comboLinkStyle.select(this.map.getDefaultLinkStyle() - 1);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboLinkStyle.setLayoutData((Object)gd);
        this.spinerLineWidth = new LabeledSpinner((Composite)linkGroup, 0);
        this.spinerLineWidth.setLabel(this.i18n.tr("Line width (0 for client default)"));
        this.spinerLineWidth.setRange(0, 100);
        this.spinerLineWidth.setSelection(this.map.getDefaultLinkWidth());
        if (this.map.getMapType() != MapType.CUSTOM) {
            Group topoGroup = new Group(dialogArea, 0);
            topoGroup.setText(this.i18n.tr("Topology options"));
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            topoGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            topoGroup.setLayout((Layout)layout);
            this.checkIncludeEndNodes = new Button((Composite)topoGroup, 32);
            this.checkIncludeEndNodes.setText(this.i18n.tr("Include &end nodes"));
            this.checkIncludeEndNodes.setSelection((this.map.getFlags() & 8) != 0);
            this.checkUseL1Topology = new Button((Composite)topoGroup, 32);
            this.checkUseL1Topology.setText(this.i18n.tr("Use &physical link information"));
            this.checkUseL1Topology.setSelection((this.map.getFlags() & 0x80) != 0);
            this.checkDontUpdateLinkText = new Button((Composite)topoGroup, 32);
            this.checkDontUpdateLinkText.setText(this.i18n.tr("Disable link &texts update"));
            this.checkDontUpdateLinkText.setSelection(this.map.isDontUpdateLinkText());
            this.checkCustomRadius = new Button((Composite)topoGroup, 32);
            this.checkCustomRadius.setText(this.i18n.tr("Custom discovery &radius"));
            this.checkCustomRadius.setSelection(this.map.getDiscoveryRadius() > 0);
            this.checkCustomRadius.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.topologyRadius = WidgetHelper.createLabeledSpinner((Composite)topoGroup, (int)2048, (String)this.i18n.tr("Topology discovery radius"), (int)1, (int)255, (Object)"WidgetHelper::default_layout_data");
            this.topologyRadius.setSelection(this.map.getDiscoveryRadius());
            this.topologyRadius.setEnabled(this.map.getDiscoveryRadius() > 0);
        }
        Group advGroup = new Group(dialogArea, 0);
        advGroup.setText(this.i18n.tr("Advanced options"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        advGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        advGroup.setLayout((Layout)layout);
        this.checkCalculateStatus = new Button((Composite)advGroup, 32);
        this.checkCalculateStatus.setText(this.i18n.tr("&Calculate map status based on contained object status"));
        this.checkCalculateStatus.setSelection((this.map.getFlags() & 0x10) != 0);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        int flags = 0;
        if (this.checkIncludeEndNodes != null && this.checkIncludeEndNodes.getSelection()) {
            flags |= 8;
        }
        if (this.checkShowStatusIcon.getSelection()) {
            flags |= 1;
        }
        if (this.checkShowStatusFrame.getSelection()) {
            flags |= 2;
        }
        if (this.checkShowStatusBkgnd.getSelection()) {
            flags |= 4;
        }
        if (this.checkCalculateStatus.getSelection()) {
            flags |= 0x10;
        }
        if (this.checkShowLinkDirection.getSelection()) {
            flags |= 0x40;
        }
        if (this.checkTranslucentLabelBkgnd.getSelection()) {
            flags |= 0x200;
        }
        if (this.checkUseL1Topology != null && this.checkUseL1Topology.getSelection()) {
            flags |= 0x80;
        }
        if (this.checkDontUpdateLinkText != null && this.checkDontUpdateLinkText.getSelection()) {
            flags |= 0x400;
        }
        md.setObjectFlags(flags, 1759);
        md.setMapObjectDisplayMode(MapObjectDisplayMode.getByValue((int)this.objectDisplayMode.getSelectionIndex()));
        md.setConnectionRouting(this.routingAlgorithm.getSelectionIndex() + 1);
        md.setNetworkMapLinkWidth(Integer.valueOf(this.spinerLineWidth.getSelection()));
        md.setNetworkMapLinkStyle(Integer.valueOf(this.comboLinkStyle.getSelectionIndex() + 1));
        if (this.radioColorCustom.getSelection()) {
            md.setLinkColor(ColorConverter.rgbToInt((RGB)this.linkColor.getColorValue()));
        } else {
            md.setLinkColor(-1);
        }
        if (this.checkCustomRadius != null) {
            if (this.checkCustomRadius.getSelection()) {
                md.setDiscoveryRadius(this.topologyRadius.getSelection());
            } else {
                md.setDiscoveryRadius(0);
            }
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

