/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.PassiveRackElementType;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImageSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class RackPassiveElementEditDialog
extends Dialog {
    private static final String[] ORIENTATION = new String[]{"Fill", "Front", "Rear"};
    private static final String[] TYPE = new String[]{"Patch panel", "Filler panel", "Organiser", "PDU"};
    private I18n i18n = LocalizationHelper.getI18n(RackPassiveElementEditDialog.class);
    private PassiveRackElement element;
    private LabeledText name;
    private Combo type;
    private Combo orientation;
    private LabeledSpinner position;
    private LabeledSpinner height;
    private String title;
    private ImageSelector frontImage;
    private ImageSelector rearImage;

    public RackPassiveElementEditDialog(Shell parentShell, PassiveRackElement element) {
        super(parentShell);
        this.element = element != null ? element : new PassiveRackElement();
        this.title = element == null ? this.i18n.tr("Add Element") : this.i18n.tr("Edit Element");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.numColumns = 4;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.element.getName());
        this.name.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Type", (Object)gd);
        this.type.setItems(TYPE);
        this.type.setText(TYPE[this.element.getType().getValue()]);
        this.position = new LabeledSpinner(dialogArea, 0);
        this.position.setLabel(this.i18n.tr("Position"));
        this.position.setRange(1, 50);
        this.position.setSelection(this.element.getPosition());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.position.setLayoutData((Object)gd);
        this.height = new LabeledSpinner(dialogArea, 0);
        this.height.setLabel(this.i18n.tr("Height"));
        this.height.setRange(1, 50);
        this.height.setSelection(this.element.getHeight());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.height.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.orientation = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Orientation", (Object)gd);
        this.orientation.setItems(ORIENTATION);
        this.orientation.setText(ORIENTATION[this.element.getOrientation().getValue()]);
        this.orientation.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.frontImage = new ImageSelector(dialogArea, 0);
        this.frontImage.setLabel(this.i18n.tr("Front image"));
        this.frontImage.setImageGuid(this.element.getFrontImage(), true);
        this.frontImage.setEnabled(this.element.getOrientation() == RackOrientation.FRONT || this.element.getOrientation() == RackOrientation.FILL);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.frontImage.setLayoutData((Object)gd);
        this.rearImage = new ImageSelector(dialogArea, 0);
        this.rearImage.setLabel(this.i18n.tr("Rear image"));
        this.rearImage.setImageGuid(this.element.getRearImage(), true);
        this.rearImage.setEnabled(this.element.getOrientation() == RackOrientation.REAR || this.element.getOrientation() == RackOrientation.FILL);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.rearImage.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.element.setPosition(this.position.getSelection());
        this.element.setHeight(this.height.getSelection());
        this.element.setOrientation(RackOrientation.getByValue((int)this.orientation.getSelectionIndex()));
        this.element.setName(this.name.getText());
        this.element.setType(PassiveRackElementType.getByValue((int)this.type.getSelectionIndex()));
        this.element.setFrontImage(this.frontImage.getImageGuid());
        this.element.setRearImage(this.rearImage.getImageGuid());
        super.okPressed();
    }

    public PassiveRackElement getElement() {
        return this.element;
    }
}

