/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.ObjectDoubleClickHandlerRegistry;
import org.netxms.nxmc.modules.networkmaps.algorithms.ManualLayout;
import org.netxms.nxmc.modules.networkmaps.views.AbstractNetworkMapView;
import org.netxms.nxmc.modules.networkmaps.views.helpers.BendpointEditor;
import org.netxms.nxmc.modules.networkmaps.views.helpers.MapImageManipulationHelper;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.FigureChangeCallback;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.LinkDciValueProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapContentProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractNetworkMapView
extends ObjectView
implements ISelectionProvider,
IZoomableWorkbenchPart {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNetworkMapView.class);
    private final I18n i18n = LocalizationHelper.getI18n(AbstractNetworkMapView.class);
    protected static final int LAYOUT_SPRING = 0;
    protected static final int LAYOUT_RADIAL = 1;
    protected static final int LAYOUT_HTREE = 2;
    protected static final int LAYOUT_VTREE = 3;
    protected static final int LAYOUT_SPARSE_VTREE = 4;
    private static final String[] layoutAlgorithmNames = new String[]{LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Spring"), LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Radial"), LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Horizontal tree"), LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Vertical tree"), LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Sparse vertical tree")};
    private static final String[] connectionRouterNames = new String[]{LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Direct"), LocalizationHelper.getI18n(AbstractNetworkMapView.class).tr("Manhattan")};
    private static final int SELECTION_EMPTY = 0;
    private static final int SELECTION_MIXED = 1;
    private static final int SELECTION_OBJECTS = 2;
    private static final int SELECTION_ELEMENTS = 3;
    private static final int SELECTION_LINKS = 4;
    protected NetworkMapPage mapPage;
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    protected MapLayoutAlgorithm layoutAlgorithm = MapLayoutAlgorithm.SPRING;
    protected int routingAlgorithm = 1;
    protected boolean allowManualLayout = false;
    protected boolean automaticLayoutEnabled = true;
    protected boolean objectMoveLocked = true;
    protected boolean readOnly = true;
    protected boolean saveSchedulted = false;
    protected Action actionShowStatusIcon;
    protected Action actionShowStatusBackground;
    protected Action actionShowStatusFrame;
    protected Action actionShowLinkDirection;
    protected Action actionTranslucentLabelBkgnd;
    protected Action actionZoomIn;
    protected Action actionZoomOut;
    protected Action actionZoomFit;
    protected Action[] actionZoomTo;
    protected Action[] actionSetAlgorithm;
    protected Action[] actionSetRouter;
    protected Action actionEnableAutomaticLayout;
    protected Action actionOpenDrillDownObject;
    protected Action actionFiguresIcons;
    protected Action actionFiguresSmallLabels;
    protected Action actionFiguresLargeLabels;
    protected Action actionFiguresStatusIcons;
    protected Action actionFiguresFloorPlan;
    protected Action actionShowGrid;
    protected Action actionShowSize;
    protected Action actionAlignToGrid;
    protected Action actionSnapToGrid;
    protected Action actionShowObjectDetails;
    protected Action actionCopyImage;
    protected Action actionSaveImage;
    protected Action actionHideLinkLabels;
    protected Action actionHideLinks;
    protected Action actionSelectAllObjects;
    protected Action actionLock;
    protected Action actionHSpanIncrease;
    protected Action actionHSpanDecrease;
    protected Action actionHSpanFull;
    protected Action actionVSpanIncrease;
    protected Action actionVSpanDecrease;
    protected Action actionShowLineChart;
    private IStructuredSelection currentSelection = new StructuredSelection(new Object[0]);
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();
    protected BendpointEditor bendpointEditor = null;
    private SessionListener sessionListener;
    private ObjectDoubleClickHandlerRegistry doubleClickHandlers;
    private LinkDciValueProvider dciValueProvider = LinkDciValueProvider.getInstance();

    public AbstractNetworkMapView(String name, ImageDescriptor image, String id) {
        super(name, image, id, false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.viewer.zoomTo(((AbstractNetworkMapView)view).viewer.getZoom());
    }

    protected abstract void buildMapPage(NetworkMapPage var1);

    public final void createContent(Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new ExtendedGraphViewer(parent, 0, (View)this, (FigureChangeCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider(this.viewer, this.labelProvider));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setBackgroundColor(parent.getDisplay().getSystemColor(25).getRGB());
        this.loadZoom(this.getObject());
        this.viewer.getGraphControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        3 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.viewer.addPostSelectionChangedListener((ISelectionChangedListener)listener);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.createActions();
        this.createContextMenu();
        if (this.automaticLayoutEnabled) {
            this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        } else {
            this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new ManualLayout());
        }
        this.doubleClickHandlers = new ObjectDoubleClickHandlerRegistry((View)this);
        this.setupMapControl();
    }

    protected void updateMapSize(int width, int height) {
        this.viewer.setMapSize(width, height);
        this.saveLayout();
    }

    protected void setMapSize(int width, int height) {
        this.viewer.setMapSize(width, height);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    protected void setupMapControl() {
    }

    public void refresh() {
        this.buildMapPage(this.mapPage);
        this.viewer.setInput((Object)this.mapPage);
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void replaceMapPage(NetworkMapPage page, Display display) {
        display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setLayoutAlgorithm(MapLayoutAlgorithm alg, boolean forceChange) {
        SpringLayoutAlgorithm algorithm;
        if (alg == MapLayoutAlgorithm.MANUAL) {
            if (!this.automaticLayoutEnabled) {
                return;
            }
            this.automaticLayoutEnabled = false;
            this.actionSetAlgorithm[this.layoutAlgorithm.getValue()].setChecked(false);
            this.actionEnableAutomaticLayout.setChecked(false);
            return;
        }
        if (this.automaticLayoutEnabled && alg == this.layoutAlgorithm && !forceChange) {
            return;
        }
        if (!this.automaticLayoutEnabled) {
            this.actionEnableAutomaticLayout.setChecked(true);
            this.automaticLayoutEnabled = true;
        }
        switch (43.$SwitchMap$org$netxms$client$maps$MapLayoutAlgorithm[alg.ordinal()]) {
            case 1: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case 2: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case 3: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case 4: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case 5: {
                algorithm = new TreeLayoutAlgorithm(1);
                ((TreeLayoutAlgorithm)algorithm).setNodeSpace(new Dimension(100, 100));
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)algorithm);
        this.actionSetAlgorithm[this.layoutAlgorithm.getValue()].setChecked(false);
        this.layoutAlgorithm = alg;
        this.actionSetAlgorithm[this.layoutAlgorithm.getValue()].setChecked(true);
    }

    protected void updateObjectPositions() {
        Graph graph = this.viewer.getGraphControl();
        List nodes = graph.getNodes();
        for (Object o : nodes) {
            Object data;
            if (!(o instanceof GraphNode) || !((data = ((GraphNode)o).getData()) instanceof NetworkMapElement)) continue;
            Point loc = ((GraphNode)o).getLocation();
            Dimension size = ((GraphNode)o).getSize();
            ((NetworkMapElement)data).setLocation(loc.x + (size.width + 1) / 2, loc.y + (size.height + 1) / 2);
        }
    }

    protected void setManualLayout() {
        this.updateObjectPositions();
        this.automaticLayoutEnabled = false;
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new ManualLayout(), true);
        for (int i = 0; i < this.actionSetAlgorithm.length; ++i) {
            this.actionSetAlgorithm[i].setEnabled(false);
        }
    }

    protected void setAutomaticLayout() {
        this.automaticLayoutEnabled = true;
        this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        for (int i = 0; i < this.actionSetAlgorithm.length; ++i) {
            this.actionSetAlgorithm[i].setEnabled(true);
        }
    }

    protected void createActions() {
        int i;
        this.actionShowLinkDirection = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLinkDirection.setChecked(this.labelProvider.isShowLinkDirection());
        this.actionShowStatusBackground = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusBackground.setEnabled(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        this.actionShowStatusIcon = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowStatusIcon.setEnabled(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        this.actionShowStatusFrame = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusFrame.setEnabled(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        this.actionTranslucentLabelBkgnd = new /* Unavailable Anonymous Inner Class!! */;
        this.actionTranslucentLabelBkgnd.setChecked(this.labelProvider.isTranslucentLabelBackground());
        this.actionZoomIn = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+=", (IAction)this.actionZoomIn);
        this.actionZoomOut = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+-", (IAction)this.actionZoomOut);
        this.actionZoomFit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+F", (IAction)this.actionZoomFit);
        this.actionZoomTo = this.viewer.createZoomActions();
        this.actionSetAlgorithm = new Action[layoutAlgorithmNames.length];
        for (i = 0; i < layoutAlgorithmNames.length; ++i) {
            MapLayoutAlgorithm alg = MapLayoutAlgorithm.getByValue((int)i);
            this.actionSetAlgorithm[i] = new /* Unavailable Anonymous Inner Class!! */;
            this.actionSetAlgorithm[i].setChecked(this.layoutAlgorithm.getValue() == i);
            this.actionSetAlgorithm[i].setEnabled(this.automaticLayoutEnabled);
        }
        this.actionSetRouter = new Action[connectionRouterNames.length];
        for (i = 0; i < connectionRouterNames.length; ++i) {
            int alg = i + 1;
            this.actionSetRouter[i] = new /* Unavailable Anonymous Inner Class!! */;
            this.actionSetRouter[i].setChecked(this.routingAlgorithm == alg);
        }
        this.actionEnableAutomaticLayout = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEnableAutomaticLayout.setChecked(this.automaticLayoutEnabled);
        this.actionLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/netmap/lock.png"));
        this.actionLock.setEnabled(true);
        this.actionOpenDrillDownObject = new /* Unavailable Anonymous Inner Class!! */;
        this.actionOpenDrillDownObject.setEnabled(false);
        this.actionFiguresIcons = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFiguresSmallLabels = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFiguresLargeLabels = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFiguresStatusIcons = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFiguresFloorPlan = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowGrid = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowGrid.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/netmap/grid.png"));
        this.actionShowGrid.setChecked(this.viewer.isGridVisible());
        this.addKeyBinding("M1+G", (IAction)this.actionShowGrid);
        this.actionShowSize = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowSize.setChecked(this.viewer.isSizeVisible());
        this.actionSnapToGrid = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSnapToGrid.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/netmap/snap_to_grid.png"));
        this.actionSnapToGrid.setChecked(this.viewer.isSnapToGrid());
        this.actionAlignToGrid = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+G", (IAction)this.actionAlignToGrid);
        this.actionShowObjectDetails = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSaveImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideLinkLabels = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideLinkLabels.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/netmap/hide_link_labels.png"));
        this.actionHideLinks = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideLinks.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/netmap/hide_links.png"));
        this.actionSelectAllObjects = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+A", (IAction)this.actionSelectAllObjects);
        this.actionHSpanIncrease = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHSpanDecrease = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHSpanFull = new /* Unavailable Anonymous Inner Class!! */;
        this.actionVSpanIncrease = new /* Unavailable Anonymous Inner Class!! */;
        this.actionVSpanDecrease = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLineChart = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+L", (IAction)this.actionShowLineChart);
    }

    protected void lockObjectMove(boolean checked) {
        this.objectMoveLocked = checked;
        this.viewer.setDraggingEnabled(!this.objectMoveLocked);
    }

    protected IContributionItem createLayoutSubmenu() {
        MenuManager layout = new MenuManager(this.i18n.tr("&Layout"));
        if (this.allowManualLayout) {
            layout.add((IAction)this.actionEnableAutomaticLayout);
        }
        layout.add((IContributionItem)new Separator());
        for (int i = 0; i < this.actionSetAlgorithm.length; ++i) {
            layout.add((IAction)this.actionSetAlgorithm[i]);
        }
        return layout;
    }

    protected IContributionItem createRoutingSubmenu() {
        MenuManager submenu = new MenuManager(this.i18n.tr("&Routing"));
        for (int i = 0; i < this.actionSetRouter.length; ++i) {
            submenu.add((IAction)this.actionSetRouter[i]);
        }
        return submenu;
    }

    protected void fillLocalMenu(IMenuManager manager) {
        MenuManager zoom = new MenuManager(this.i18n.tr("&Zoom"));
        for (int i = 0; i < this.actionZoomTo.length; ++i) {
            zoom.add((IAction)this.actionZoomTo[i]);
        }
        if (!this.readOnly) {
            manager.add((IAction)this.actionLock);
            manager.add((IContributionItem)new Separator());
        }
        MenuManager figureType = new MenuManager(this.i18n.tr("&Display objects as"));
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        figureType.add((IAction)this.actionFiguresStatusIcons);
        figureType.add((IAction)this.actionFiguresFloorPlan);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IAction)this.actionShowLinkDirection);
        manager.add((IAction)this.actionTranslucentLabelBkgnd);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IAction)this.actionZoomFit);
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHSpanIncrease);
        manager.add((IAction)this.actionHSpanDecrease);
        manager.add((IAction)this.actionHSpanFull);
        manager.add((IAction)this.actionVSpanIncrease);
        manager.add((IAction)this.actionVSpanDecrease);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IAction)this.actionShowSize);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideLinkLabels);
        manager.add((IAction)this.actionHideLinks);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyImage);
        manager.add((IAction)this.actionSaveImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAllObjects);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IAction)this.actionZoomFit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHSpanIncrease);
        manager.add((IAction)this.actionHSpanDecrease);
        manager.add((IAction)this.actionHSpanFull);
        manager.add((IAction)this.actionVSpanIncrease);
        manager.add((IAction)this.actionVSpanDecrease);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideLinkLabels);
        manager.add((IAction)this.actionHideLinks);
        manager.add((IContributionItem)new Separator());
        if (!this.readOnly) {
            manager.add((IAction)this.actionLock);
        }
        manager.add((IAction)this.actionCopyImage);
    }

    private void createContextMenu() {
        41 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillObjectContextMenu(IMenuManager manager, boolean isPartial) {
        manager.add((IAction)this.actionOpenDrillDownObject);
        if (this.currentSelection.size() == 1 && !isPartial) {
            manager.add((IAction)this.actionShowObjectDetails);
        }
    }

    protected void fillElementContextMenu(IMenuManager manager) {
    }

    protected void fillLinkContextMenu(IMenuManager manager) {
        if (this.currentSelection.size() == 1 && this.selectedLinkHasData()) {
            manager.add((IAction)this.actionShowLineChart);
        }
    }

    protected void fillMapContextMenu(IMenuManager manager) {
        MenuManager zoom = new MenuManager(this.i18n.tr("&Zoom"));
        for (int i = 0; i < this.actionZoomTo.length; ++i) {
            zoom.add((IAction)this.actionZoomTo[i]);
        }
        MenuManager figureType = new MenuManager(this.i18n.tr("&Display objects as"));
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        figureType.add((IAction)this.actionFiguresStatusIcons);
        figureType.add((IAction)this.actionFiguresFloorPlan);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IAction)this.actionShowLinkDirection);
        manager.add((IAction)this.actionTranslucentLabelBkgnd);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IAction)this.actionZoomFit);
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IAction)this.actionShowSize);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideLinkLabels);
        manager.add((IAction)this.actionHideLinks);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAllObjects);
    }

    private int analyzeSelection(IStructuredSelection selection) {
        Class<AbstractObject> firstClass;
        int type;
        if (selection.isEmpty()) {
            return 0;
        }
        Iterator it = selection.iterator();
        Object first = it.next();
        if (first instanceof AbstractObject) {
            type = 2;
            firstClass = AbstractObject.class;
        } else if (first instanceof NetworkMapElement) {
            type = 3;
            firstClass = NetworkMapElement.class;
        } else if (first instanceof NetworkMapLink) {
            type = 4;
            firstClass = NetworkMapLink.class;
        } else {
            return 1;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (firstClass.isInstance(o)) continue;
            return 1;
        }
        return type;
    }

    protected void processObjectUpdateNotification(AbstractObject object) {
        List links;
        if (this.mapPage == null) {
            return;
        }
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh((Object)element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh((Object)l);
            }
        }
    }

    protected void saveLayout() {
    }

    public void setFocus() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.mapPage != null) {
            this.dciValueProvider.removeDcis(this.mapPage);
        }
        super.dispose();
    }

    void fullDciCacheRefresh() {
        if (this.mapPage != null) {
            this.dciValueProvider.removeDcis(this.mapPage);
            this.refreshDciRequestList(this.mapPage, false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    private IStructuredSelection transformSelection(ISelection viewerSelection) {
        IStructuredSelection selection = (IStructuredSelection)viewerSelection;
        if (selection.isEmpty()) {
            return selection;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object element : selection) {
            if (element instanceof NetworkMapObject) {
                AbstractObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId(), true);
                if (object != null) {
                    objects.add(object);
                    continue;
                }
                objects.add(element);
                continue;
            }
            if (!this.isSelectableElement(element)) continue;
            objects.add(element);
        }
        return new StructuredSelection(objects.toArray());
    }

    protected boolean isSelectableElement(Object element) {
        return false;
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    private void openDrillDownObject() {
        if (this.currentSelection == null || this.currentSelection.isEmpty()) {
            return;
        }
        Object currentObject = this.currentSelection.getFirstElement();
        long drillDownObjectId = 0L;
        if (currentObject instanceof AbstractObject) {
            drillDownObjectId = currentObject instanceof NetworkMap ? ((AbstractObject)currentObject).getObjectId() : ((AbstractObject)currentObject).getDrillDownObjectId();
        } else if (currentObject instanceof NetworkMapTextBox) {
            drillDownObjectId = ((NetworkMapTextBox)currentObject).getDrillDownObjectId();
        }
        if (drillDownObjectId != 0L) {
            this.doubleClickHandlers.openDrillDownObjectView(drillDownObjectId, this.getObject());
        }
    }

    protected boolean selectedLinkHasData() {
        Object o = this.currentSelection.getFirstElement();
        return o != null && o instanceof NetworkMapLink && ((NetworkMapLink)o).hasDciData();
    }

    private void showLinkLineChart() {
        NetworkMapLink link = (NetworkMapLink)this.currentSelection.getFirstElement();
        if (!link.hasDciData()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setConnectionRouter(int routingAlgorithm, boolean doSave) {
        switch (routingAlgorithm) {
            case 2: {
                this.routingAlgorithm = 2;
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                this.routingAlgorithm = 1;
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        for (int i = 0; i < this.actionSetRouter.length; ++i) {
            this.actionSetRouter[i].setChecked(routingAlgorithm == i + 1);
        }
        if (doSave) {
            this.updateObjectPositions();
            this.saveLayout();
        }
        this.viewer.refresh();
    }

    private void showObjectDetails() {
        if (this.currentSelection.size() != 1 || !(this.currentSelection.getFirstElement() instanceof AbstractObject)) {
            return;
        }
        AbstractObject object = (AbstractObject)this.currentSelection.getFirstElement();
        MainWindow.switchToObject((long)object.getObjectId(), (long)0L);
    }

    protected void refreshDciRequestList(NetworkMapPage oldMapPage, boolean removeOldMapDci) {
        Collection linkList = this.mapPage.getLinks();
        for (NetworkMapLink item : linkList) {
            if (!item.hasDciData()) continue;
            for (SingleDciConfig value : item.getDciAsList()) {
                if (value.type == 1) {
                    this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    continue;
                }
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
            }
        }
        Collection mapElements = this.mapPage.getElements();
        for (NetworkMapElement element : mapElements) {
            NetworkMapDCIContainer item;
            if (element instanceof NetworkMapDCIContainer && (item = (NetworkMapDCIContainer)element).hasDciData()) {
                for (SingleDciConfig value : item.getObjectDCIArray()) {
                    if (value.type == 1) {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                        continue;
                    }
                    this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
                }
            }
            if (!(element instanceof NetworkMapDCIImage)) continue;
            item = (NetworkMapDCIImage)element;
            DCIImageConfiguration config = item.getImageOptions();
            SingleDciConfig value = config.getDci();
            if (value.type == 1) {
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                continue;
            }
            this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
        }
        if (oldMapPage != null && oldMapPage.getMapObjectId() != 0L && removeOldMapDci) {
            this.dciValueProvider.removeDcis(oldMapPage);
        }
    }

    protected void setObjectDisplayMode(MapObjectDisplayMode mode, boolean saveLayout) {
        this.labelProvider.setObjectFigureType(mode);
        if (saveLayout) {
            this.updateObjectPositions();
            this.saveLayout();
        }
        this.viewer.refresh(true);
        this.actionShowStatusBackground.setEnabled(mode == MapObjectDisplayMode.ICON);
        this.actionShowStatusFrame.setEnabled(mode == MapObjectDisplayMode.ICON);
        this.actionShowStatusIcon.setEnabled(mode == MapObjectDisplayMode.ICON);
        this.actionFiguresIcons.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        this.actionFiguresSmallLabels.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.SMALL_LABEL);
        this.actionFiguresLargeLabels.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL);
        this.actionFiguresStatusIcons.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.STATUS);
        this.actionFiguresFloorPlan.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.FLOOR_PLAN);
    }

    public boolean saveMapImageToFile(String fileName) {
        return MapImageManipulationHelper.saveMapImageToFile((Shell)this.getWindow().getShell(), (ExtendedGraphViewer)this.viewer, (Logger)logger, (String)fileName);
    }

    protected void onElementMove(NetworkMapElement element) {
    }

    public void onLinkChange(NetworkMapLink link) {
    }

    protected void saveZoom(AbstractObject object) {
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(this.getBaseId() + ".zoom", this.viewer.getZoom());
    }

    protected void loadZoom(AbstractObject object) {
        PreferenceStore settings = PreferenceStore.getInstance();
        this.viewer.zoomTo(settings.getAsDouble(this.getBaseId() + ".zoom", 1.0));
    }

    static /* synthetic */ NXCSession access$000(AbstractNetworkMapView x0) {
        return x0.session;
    }
}

