/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.objecttools.ObjectAction;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.SaveGraphDlg;
import org.netxms.nxmc.modules.datacollection.propertypages.GeneralChart;
import org.netxms.nxmc.modules.datacollection.propertypages.Graph;
import org.netxms.nxmc.modules.datacollection.propertypages.TemplateDataSources;
import org.netxms.nxmc.modules.datacollection.views.TemplateGraphView;
import org.netxms.nxmc.modules.datacollection.views.helpers.TemplateGraphLabelProvider;
import org.netxms.nxmc.modules.objecttools.propertypages.Filter;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class TemplateGraphView
extends ConfigurationView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(TemplateGraphView.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DCI_NAME = 1;
    public static final int COLUMN_DCI_DESCRIPTION = 2;
    private NXCSession session = Registry.getSession();
    private SortableTableViewer viewer;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionAdd;
    private boolean updateInProgress = false;
    private List<GraphDefinition> graphList;

    public TemplateGraphView() {
        super(LocalizationHelper.getI18n(TemplateGraphView.class).tr("Template Graphs"), ResourceManager.getImageDescriptor((String)"icons/object-views/chart-line.png"), "configuration.template-graphs", false);
    }

    public void createContent(Composite parent) {
        String[] names = new String[]{"Graph name", "DCI names", "DCI descriptions"};
        int[] widths = new int[]{150, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TemplateGraphLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.refresh();
        this.session.addListener((SessionListener)this);
    }

    private void createActions() {
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdd = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void saveGraph(String graphName, String errorMessage, boolean canBeOverwritten) {
        SaveGraphDlg dlg = new SaveGraphDlg(this.getWindow().getShell(), graphName, errorMessage, canBeOverwritten);
        int result = dlg.open();
        if (result == 1) {
            return;
        }
        GraphDefinition gs = new GraphDefinition(0L, (long)this.session.getUserId(), 0, new ArrayList(0));
        gs.setName(dlg.getName());
        gs.setFlags(1);
        if (result == 101) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1028: {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1012: {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void editTemplateGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        GraphDefinition settings = (GraphDefinition)selection.getFirstElement();
        if (this.showGraphPropertyPages(settings)) {
            GraphDefinition newSettings = settings;
            try {
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getWindow().getShell(), (String)"Internal Error", (String)String.format("Unexpected exception: %s", e.getLocalizedMessage()));
            }
        }
    }

    private void deletePredefinedGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Predefined Graphs"), (String)this.i18n.tr("Selected predefined graphs will be deleted. Are you sure?"))) {
            return;
        }
        for (Object o : selection.toList()) {
            if (!(o instanceof GraphDefinition)) continue;
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private boolean showGraphPropertyPages(GraphDefinition settings) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("graph", (IPreferencePage)new Graph(settings, true)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new GeneralChart((ChartConfiguration)settings, true)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("filter", (IPreferencePage)new Filter((ObjectAction)settings)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("template", (IPreferencePage)new TemplateDataSources(settings, true)));
        13 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

