/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.dialogs.TwoFactorAuthMethodEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.TwoFactorMethodLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.TwoFactorMethodListComparator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TwoFactorAuthenticationMethods
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.TwoFactorAuthenticationMethods";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DRIVER = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener listener;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionNewMethod;
    private Action actionEditMethod;
    private Action actionDeleteMethod;

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{160, 120, 80, 500};
        String[] names = new String[]{"Name", "Driver", "Status", "Description"};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TwoFactorMethodLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TwoFactorMethodListComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TwoFactorAuthenticationMethods.this.editMethod();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = TwoFactorAuthenticationMethods.this.viewer.getStructuredSelection();
                TwoFactorAuthenticationMethods.this.actionEditMethod.setEnabled(selection.size() == 1);
                TwoFactorAuthenticationMethods.this.actionDeleteMethod.setEnabled(selection.size() > 0);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"TwoFactorAuthenticationMethods");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)TwoFactorAuthenticationMethods.this.viewer, (IDialogSettings)settings, (String)"TwoFactorAuthenticationMethods");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1056) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TwoFactorAuthenticationMethods.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    public void dispose() {
        if (this.listener != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TwoFactorAuthenticationMethods.this.refresh();
            }
        };
        this.actionNewMethod = new Action("&New...", SharedIcons.ADD_OBJECT){

            public void run() {
                TwoFactorAuthenticationMethods.this.createNewMethod();
            }
        };
        this.actionEditMethod = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                TwoFactorAuthenticationMethods.this.editMethod();
            }
        };
        this.actionEditMethod.setEnabled(false);
        this.actionDeleteMethod = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                TwoFactorAuthenticationMethods.this.deleteMethods();
            }
        };
        this.actionDeleteMethod.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewMethod);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewMethod);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TwoFactorAuthenticationMethods.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewMethod);
        mgr.add((IAction)this.actionEditMethod);
        mgr.add((IAction)this.actionDeleteMethod);
    }

    private void refresh() {
        new ConsoleJob("Get two-factor authentication methods", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List methods = TwoFactorAuthenticationMethods.this.session.get2FAMethods();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).TwoFactorAuthenticationMethods.this.viewer.setInput((Object)methods);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of two-factor authentication methods";
            }
        }.start();
    }

    private void createNewMethod() {
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getSite().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        final TwoFactorAuthenticationMethod method = dlg.getMethod();
        new ConsoleJob("Create two-factor authentication method", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                TwoFactorAuthenticationMethods.this.session.modify2FAMethod(method);
            }

            protected String getErrorMessage() {
                return "Cannot create two-factor authentication method";
            }
        }.start();
    }

    private void editMethod() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final TwoFactorAuthenticationMethod method = (TwoFactorAuthenticationMethod)selection.getFirstElement();
        final TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getSite().getShell(), method);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Update two-factor authentication method", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                TwoFactorAuthenticationMethods.this.session.modify2FAMethod(method);
                if (dlg.isNameChanged()) {
                    TwoFactorAuthenticationMethods.this.session.rename2FAMethod(method.getName(), dlg.getNewName());
                }
            }

            protected String getErrorMessage() {
                return "Cannot update two-factor authentication method";
            }
        }.start();
    }

    private void deleteMethods() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Methods", (String)"Are you sure you want to delete selected methods?")) {
            return;
        }
        final ArrayList<String> methods = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof TwoFactorAuthenticationMethod)) continue;
            methods.add(((TwoFactorAuthenticationMethod)o).getName());
        }
        new ConsoleJob("Delete two-factor authentication method", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String name : methods) {
                    TwoFactorAuthenticationMethods.this.session.delete2FAMethod(name);
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete two-factor authentication method";
            }
        }.start();
    }
}

