/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SpanningTreePortState {
    UNKNOWN(0, ""),
    DISABLED(1, "DISABLED"),
    BLOCKING(2, "BLOCKING"),
    LISTENING(3, "LISTENING"),
    LEARNING(4, "LEARNING"),
    FORWARDING(5, "FORWARDING"),
    BROKEN(6, "BROKEN");

    private static Logger logger;
    private static Map<Integer, SpanningTreePortState> lookupTable;
    private int value;
    private String text;

    static {
        logger = LoggerFactory.getLogger(SpanningTreePortState.class);
        lookupTable = new HashMap<Integer, SpanningTreePortState>();
        SpanningTreePortState[] spanningTreePortStateArray = SpanningTreePortState.values();
        int n = spanningTreePortStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpanningTreePortState element = spanningTreePortStateArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private SpanningTreePortState(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public static SpanningTreePortState getByValue(int value) {
        SpanningTreePortState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

