/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.RoutingProtocol;
import org.netxms.client.topology.Route;

public class RoutingTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Route r = (Route)element;
        switch (columnIndex) {
            case 0: {
                return r.getDestination().toString();
            }
            case 2: {
                return r.getIfName();
            }
            case 4: {
                return Integer.toString(r.getMetric());
            }
            case 1: {
                return r.getNextHop().getHostAddress();
            }
            case 5: {
                return this.getProtocolName(r.getProtocol());
            }
            case 3: {
                return Integer.toString(r.getType());
            }
        }
        return null;
    }

    private String getProtocolName(RoutingProtocol protocol) {
        switch (protocol) {
            case BBN_SPF_IGP: {
                return "BBN SPF IGP";
            }
            case ES_IS: {
                return "ES-IS";
            }
            case IS_IS: {
                return "IS-IS";
            }
            case LOCAL: {
                return "Local";
            }
            case NETMGMT: {
                return "Network Management";
            }
            case OTHER: {
                return "Other";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return protocol.toString();
    }
}

