/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventReference;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EventReferenceViewDialog;
import org.xnap.commons.i18n.I18n;

public class EventReferenceViewDialog
extends Dialog {
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_ID = 1;
    private static final int COLUMN_NAME = 2;
    private static final int COLUMN_DESCRIPTION = 3;
    private static final int COLUMN_OWNER_ID = 4;
    private static final int COLUMN_OWNER_NAME = 5;
    private I18n i18n = LocalizationHelper.getI18n(EventReferenceViewDialog.class);
    private NXCSession session = Registry.getSession();
    private List<EventReference> references;
    private SortableTableViewer viewer;
    private String eventName;
    private boolean showWarning;
    private boolean multiChoice;

    public EventReferenceViewDialog(Shell parentShell, String eventName, List<EventReference> references, boolean showWarning, boolean multiChoice) {
        super(parentShell);
        this.references = references;
        this.eventName = eventName;
        this.showWarning = showWarning;
        this.multiChoice = multiChoice;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.showWarning ? "Warning" : String.format("Event References - %s", this.eventName));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.showWarning) {
            if (this.multiChoice) {
                this.createButton(parent, 2, this.i18n.tr("&Yes"), true);
                this.createButton(parent, 4, this.i18n.tr("Yes To &All"), false);
                this.createButton(parent, 3, this.i18n.tr("&No"), false);
                this.createButton(parent, 21, this.i18n.tr("N&o To All"), false);
            } else {
                this.createButton(parent, 2, this.i18n.tr("&Yes"), true);
                this.createButton(parent, 3, this.i18n.tr("&No"), false);
            }
        } else {
            this.createButton(parent, 1, this.i18n.tr("Close"), false);
        }
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        if (this.showWarning) {
            Composite warningArea = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 4;
            layout.numColumns = 2;
            warningArea.setLayout((Layout)layout);
            Label label = new Label(warningArea, 0);
            label.setImage(parent.getDisplay().getSystemImage(8));
            label = new Label(warningArea, 16384);
            label.setText(String.format("Event %s is used in the following entities. Deleting it may cause unexpected system behavior. Are you sure?", this.eventName));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        }
        String[] names = new String[]{"Type", "ID", "Name", "Description", "Owner ID", "Owner name"};
        int[] widths = new int[]{150, 100, 200, 200, 100, 200};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReferenceLabelProvider(this));
        this.viewer.setComparator((ViewerComparator)new ReferenceComparator(this));
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setInput((Object)this.references);
        this.viewer.packColumns();
        return dialogArea;
    }

    private String getObjectPath(long objectId, String fallbackName) {
        AbstractObject object = this.session.findObjectById(objectId);
        if (object == null) {
            return fallbackName;
        }
        return object.getObjectNameWithPath();
    }
}

