/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.NetworkMapConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.networkmaps.widgets.NetworkMapWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkMapElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(NetworkMapElement.class);
    private NetworkMap mapObject;
    private NetworkMapWidget mapWidget;
    private NetworkMapConfig config;

    public NetworkMapElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = (NetworkMapConfig)XMLTools.createFromXml(NetworkMapConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new NetworkMapConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        NXCSession session = Registry.getSession();
        this.mapObject = (NetworkMap)session.findObjectById(this.config.getObjectId(), NetworkMap.class);
        if (this.mapObject != null) {
            this.mapWidget = new NetworkMapWidget(this.getContentArea(), 0, (View)view);
            this.mapWidget.setContent(this.mapObject);
            this.mapWidget.zoomTo((double)this.config.getZoomLevel() / 100.0);
        }
        if (this.config.isObjectDoubleClickEnabled()) {
            this.mapWidget.enableObjectDoubleClick();
        }
        if (this.config.isHideLinkLabelsEnabled()) {
            this.mapWidget.hideLinkLabels(true);
        }
    }

    protected int getPreferredHeight() {
        return 600;
    }
}

