/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.AbstractChartConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ScriptedComparisonChartConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.propertypages.helpers.DciListLabelProvider;
import org.netxms.nxmc.modules.datacollection.dialogs.DataSourceEditDlg;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectDciDialog;
import org.xnap.commons.i18n.I18n;

public class DataSources
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(DataSources.class);
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_METRIC_DISPLAYNAME = 2;
    public static final int COLUMN_METRIC = 3;
    public static final int COLUMN_LABEL = 4;
    public static final int COLUMN_COLOR = 5;
    private AbstractChartConfig config;
    private DciListLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button addTemplateButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<ChartDciConfig> dciList = null;

    public DataSources(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(DataSources.class).tr("Data Sources"), elementConfig);
    }

    public String getId() {
        return "data-sources";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof AbstractChartConfig && !(this.elementConfig instanceof ScriptedComparisonChartConfig);
    }

    public int getPriority() {
        return 20;
    }

    protected Control createContents(Composite parent) {
        this.config = (AbstractChartConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        this.dciList = new ArrayList();
        for (ChartDciConfig dci : this.config.getDciList()) {
            this.dciList.add(new ChartDciConfig(dci));
        }
        this.labelProvider = new DciListLabelProvider(this.dciList);
        this.labelProvider.resolveDciNames((Collection)this.dciList);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Pos"), this.i18n.tr("Node"), this.i18n.tr("DCI Display name"), this.i18n.tr("Metric"), this.i18n.tr("Label"), this.i18n.tr("Color")};
        int[] columnWidths = new int[]{40, 130, 200, 200, 150, 50};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput((Object)this.dciList);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonLayout.marginWidth = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        GridData gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.upButton.setLayoutData((Object)gd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("Dow&n"));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.downButton.setLayoutData((Object)gd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new GridLayout();
        buttonLayout.numColumns = 4;
        buttonLayout.marginWidth = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addTemplateButton = new Button(rightButtons, 8);
        this.addTemplateButton.setText(this.i18n.tr("Add &template..."));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.addTemplateButton.setLayoutData((Object)gd);
        this.addTemplateButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText(this.i18n.tr("&Edit..."));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addItem() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), 0L);
        if (dlg.open() == 0) {
            List selection = dlg.getSelection();
            ArrayList<ChartDciConfig> newSelection = new ArrayList<ChartDciConfig>();
            for (DciValue v : selection) {
                ChartDciConfig dci = new ChartDciConfig(v);
                newSelection.add(dci);
                this.labelProvider.addCacheEntry(dci.nodeId, dci.dciId, v.getName(), v.getDescription());
                this.dciList.add(dci);
            }
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    private void addTemplateItem() {
        ChartDciConfig dci = new ChartDciConfig();
        DataSourceEditDlg dlg = new DataSourceEditDlg(this.getShell(), dci, true, true);
        if (dlg.open() == 0) {
            this.dciList.add(dci);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)dci));
        }
    }

    private void editItem() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        ChartDciConfig dci = (ChartDciConfig)selection.getFirstElement();
        if (dci == null) {
            return;
        }
        DataSourceEditDlg dlg = new DataSourceEditDlg(this.getShell(), dci, false, dci.getDciId() == 0L);
        if (dlg.open() == 0) {
            this.labelProvider.resolveDciNames((Collection)this.dciList);
            this.viewer.update((Object)dci, null);
        }
    }

    private void deleteItems() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.dciList.remove(o);
        }
        this.viewer.refresh();
    }

    private void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.dciList, index - 1, index);
            this.viewer.refresh();
        }
    }

    private void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) < this.dciList.size() - 1 && index >= 0) {
            Collections.swap(this.dciList, index + 1, index);
            this.viewer.refresh();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.config.setDciList(this.dciList.toArray(new ChartDciConfig[this.dciList.size()]));
        return true;
    }
}

