/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.NetworkMapConfig;
import org.netxms.ui.eclipse.networkmaps.widgets.NetworkMapWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NetworkMapElement
extends ElementWidget {
    private NetworkMap mapObject;
    private NetworkMapWidget mapWidget;
    private NetworkMapConfig config;

    public NetworkMapElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (NetworkMapConfig)XMLTools.createFromXml(NetworkMapConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new NetworkMapConfig();
        }
        this.processCommonSettings(this.config);
        NXCSession session = ConsoleSharedData.getSession();
        this.mapObject = (NetworkMap)session.findObjectById(this.config.getObjectId(), NetworkMap.class);
        if (this.mapObject != null) {
            this.mapWidget = new NetworkMapWidget(this.getContentArea(), viewPart, 0);
            this.mapWidget.setContent(this.mapObject);
            this.mapWidget.zoomTo((double)this.config.getZoomLevel() / 100.0);
        }
        if (this.config.isObjectDoubleClickEnabled()) {
            this.mapWidget.enableObjectDoubleClick();
        }
    }

    @Override
    protected int getPreferredHeight() {
        return 600;
    }
}

