/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmHandle;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.ZoneMember;
import org.netxms.client.search.SearchAttributeProvider;
import org.netxms.client.search.SearchQuery;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmListFilter
extends ViewerFilter {
    private Set<Long> rootObjects = new HashSet<Long>();
    private int stateFilter = 255;
    private int severityFilter = 255;
    private NXCSession session = ConsoleSharedData.getSession();
    private String filterString = null;
    private SearchQuery query = null;
    private static final String[] STATE_TEXT = new String[]{"Outstanding", "Acknowledged", "Resolved", "Terminated"};

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.query == null) {
            return true;
        }
        final Alarm alarm = ((AlarmHandle)element).alarm;
        return this.query.match((Object)new SearchAttributeProvider(){

            public String getText() {
                return alarm.getMessage();
            }

            public String getAttribute(String name) {
                if (name.equals("acknowledgedby")) {
                    AbstractUserObject user = AlarmListFilter.this.session.findUserDBObjectById(alarm.getAcknowledgedByUser(), null);
                    return user != null ? user.getName() : null;
                }
                if (name.equals("event")) {
                    return AlarmListFilter.this.session.getEventName(alarm.getSourceEventCode());
                }
                if (name.equals("hascomments")) {
                    return alarm.getCommentsCount() > 0 ? "yes" : "no";
                }
                if (name.equals("repeatcount")) {
                    return Integer.toString(alarm.getRepeatCount());
                }
                if (name.equals("resolvedby")) {
                    AbstractUserObject user = AlarmListFilter.this.session.findUserDBObjectById(alarm.getResolvedByUser(), null);
                    return user != null ? user.getName() : null;
                }
                if (name.equals("severity")) {
                    return alarm.getCurrentSeverity().toString();
                }
                if (name.equals("source")) {
                    return AlarmListFilter.this.session.getObjectName(alarm.getSourceObjectId());
                }
                if (name.equals("state")) {
                    return STATE_TEXT[alarm.getState()];
                }
                if (name.equals("zone") && AlarmListFilter.this.session.isZoningEnabled()) {
                    ZoneMember zm = (ZoneMember)AlarmListFilter.this.session.findObjectById(alarm.getSourceObjectId(), ZoneMember.class);
                    return zm != null ? zm.getZoneName() : null;
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filter(Alarm alarm) {
        if ((alarm.getStateBit() & this.stateFilter) == 0) {
            return false;
        }
        if ((1 << alarm.getCurrentSeverity().getValue() & this.severityFilter) == 0) {
            return false;
        }
        Set<Long> set = this.rootObjects;
        synchronized (set) {
            block8: {
                if (!this.rootObjects.isEmpty() && !this.rootObjects.contains(alarm.getSourceObjectId())) break block8;
                return true;
            }
            AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
            if (object != null) {
                long[] rootObjectsArray = new long[this.rootObjects.size()];
                int i = 0;
                for (long objectId : this.rootObjects) {
                    rootObjectsArray[i++] = objectId;
                }
                return object.isChildOf(rootObjectsArray);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRootObject(long rootObject) {
        Set<Long> set = this.rootObjects;
        synchronized (set) {
            this.rootObjects.clear();
            this.rootObjects.add(rootObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootObjects(List<Long> selectedObjects) {
        Set<Long> set = this.rootObjects;
        synchronized (set) {
            this.rootObjects.clear();
            this.rootObjects.addAll(selectedObjects);
        }
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        if (filterString == null) {
            this.filterString = null;
            this.query = null;
            return;
        }
        String s = filterString.toLowerCase().trim();
        if (!s.equals(this.filterString)) {
            this.filterString = s;
            this.query = !s.isEmpty() ? new SearchQuery(s) : null;
        }
    }
}

