/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.Pair;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.base.propertypages.PropertyDialog;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.ShowHistoricalDataMenuItems;
import org.netxms.nxmc.modules.datacollection.propertypages.AccessControl;
import org.netxms.nxmc.modules.datacollection.propertypages.ClusterOptions;
import org.netxms.nxmc.modules.datacollection.propertypages.Comments;
import org.netxms.nxmc.modules.datacollection.propertypages.CustomSchedule;
import org.netxms.nxmc.modules.datacollection.propertypages.General;
import org.netxms.nxmc.modules.datacollection.propertypages.InstanceDiscovery;
import org.netxms.nxmc.modules.datacollection.propertypages.OtherOptions;
import org.netxms.nxmc.modules.datacollection.propertypages.OtherOptionsTable;
import org.netxms.nxmc.modules.datacollection.propertypages.PerformanceView;
import org.netxms.nxmc.modules.datacollection.propertypages.SNMP;
import org.netxms.nxmc.modules.datacollection.propertypages.TableColumns;
import org.netxms.nxmc.modules.datacollection.propertypages.TableThresholds;
import org.netxms.nxmc.modules.datacollection.propertypages.Thresholds;
import org.netxms.nxmc.modules.datacollection.propertypages.Transformation;
import org.netxms.nxmc.modules.datacollection.propertypages.WinPerf;
import org.netxms.nxmc.modules.datacollection.views.BaseDataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.datacollection.views.TableLastValuesView;
import org.netxms.nxmc.modules.datacollection.views.helpers.LastValuesComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.LastValuesFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.LastValuesLabelProvider;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.netxms.nxmc.tools.VisibilityValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class BaseDataCollectionView
extends ObjectView
implements ViewerProvider {
    private final I18n i18n = LocalizationHelper.getI18n(BaseDataCollectionView.class);
    public static final int LV_COLUMN_OWNER = 0;
    public static final int LV_COLUMN_ID = 1;
    public static final int LV_COLUMN_DESCRIPTION = 2;
    public static final int LV_COLUMN_VALUE = 3;
    public static final int LV_COLUMN_TIMESTAMP = 4;
    public static final int LV_COLUMN_THRESHOLD = 5;
    public static final int LV_COLUMN_EVENT = 6;
    public static final int LV_COLUMN_MESSAGE = 7;
    public static final int LV_COLUMN_COMMENTS = 8;
    protected SortableTableViewer viewer;
    private LastValuesLabelProvider labelProvider;
    private LastValuesComparator comparator;
    private LastValuesFilter lvFilter;
    private boolean autoRefreshEnabled = false;
    private int autoRefreshInterval = 30;
    private ViewRefreshController refreshController;
    protected Action actionUseMultipliers;
    protected Action actionShowErrors;
    protected Action actionShowDisabled;
    protected Action actionShowUnsupported;
    protected Action actionShowHidden;
    protected ExportToCsvAction actionExportToCsv;
    protected ExportToCsvAction actionExportAllToCsv;
    protected Action actionCopyToClipboard;
    protected Action actionCopyValueToClipboard;
    protected Action actionCopyDciName;
    protected Action actionForcePoll;
    protected Action actionRecalculateData;
    protected Action actionClearData;

    public BaseDataCollectionView(String name, String id, boolean hasFilter) {
        super(name, ResourceManager.getImageDescriptor((String)"icons/object-views/last_values.png"), id, hasFilter);
    }

    protected void createContent(Composite parent) {
        1 validator = new /* Unavailable Anonymous Inner Class!! */;
        this.createActions();
        this.createLastValuesViewer(parent, (VisibilityValidator)validator);
    }

    protected void createLastValuesViewer(Composite parent, VisibilityValidator validator) {
        parent.setLayout((Layout)new FillLayout());
        String[] names = new String[]{this.i18n.tr("Owner"), this.i18n.tr("ID"), this.i18n.tr("Display name"), this.i18n.tr("Value"), this.i18n.tr("Timestamp"), this.i18n.tr("Threshold"), this.i18n.tr("Event"), this.i18n.tr("Message"), this.i18n.tr("Comments")};
        int[] widths = new int[]{250, 70, 250, 150, 120, 150, 250, 250, 250};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, -1);
        this.labelProvider = new LastValuesLabelProvider(this.viewer);
        this.comparator = new LastValuesComparator();
        this.lvFilter = new LastValuesFilter();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.viewer.addFilter((ViewerFilter)this.lvFilter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.lvFilter);
        if (this.isHideOwner()) {
            this.viewer.removeColumnById(0);
        }
        this.actionExportToCsv.setViewer((ColumnViewer)this.viewer);
        this.actionExportAllToCsv.setViewer((ColumnViewer)this.viewer);
        this.postLastValueViewCreation("LastValues", validator);
    }

    protected boolean isHideOwner() {
        return true;
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ShowHistoricalDataMenuItems.populateMenu((IMenuManager)manager, (View)this, (AbstractObject)this.getObject(), (StructuredViewer)this.viewer, (int)this.getDciSelectionType());
        MenuManager export = new MenuManager(this.i18n.tr("E&xport"));
        export.add((IAction)this.actionExportToCsv);
        export.add((IAction)this.actionExportAllToCsv);
        export.add((IAction)this.actionCopyToClipboard);
        export.add((IAction)this.actionCopyDciName);
        export.add((IAction)this.actionCopyValueToClipboard);
        manager.add((IContributionItem)export);
        MenuManager actions = new MenuManager(this.i18n.tr("A&ctions"));
        actions.add((IAction)this.actionForcePoll);
        actions.add((IAction)this.actionRecalculateData);
        actions.add((IAction)this.actionClearData);
        manager.add((IContributionItem)actions);
        MenuManager viewOptions = new MenuManager(this.i18n.tr("V&iew options"));
        viewOptions.add((IAction)this.actionUseMultipliers);
        viewOptions.add((IAction)this.actionShowErrors);
        viewOptions.add((IAction)this.actionShowDisabled);
        viewOptions.add((IAction)this.actionShowUnsupported);
        viewOptions.add((IAction)this.actionShowHidden);
        manager.add((IContributionItem)viewOptions);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IAction)this.actionShowErrors);
        manager.add((IAction)this.actionShowDisabled);
        manager.add((IAction)this.actionShowUnsupported);
        manager.add((IAction)this.actionShowHidden);
    }

    protected void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.actionUseMultipliers = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUseMultipliers.setChecked(this.areMultipliersUsed());
        this.addKeyBinding("M1+M3+M", (IAction)this.actionUseMultipliers);
        this.actionShowErrors = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowErrors.setChecked(this.isShowErrors());
        this.addKeyBinding("M1+M3+E", (IAction)this.actionShowErrors);
        this.actionShowUnsupported = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowUnsupported.setChecked(this.isShowUnsupported());
        this.addKeyBinding("M1+M3+U", (IAction)this.actionShowUnsupported);
        this.actionShowHidden = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowHidden.setChecked(this.isShowHidden());
        this.addKeyBinding("M1+M3+H", (IAction)this.actionShowHidden);
        this.actionShowDisabled = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowDisabled.setChecked(this.isShowDisabled());
        this.addKeyBinding("M1+M3+D", (IAction)this.actionShowDisabled);
        this.actionCopyToClipboard = new CopyTableRowsAction((ViewerProvider)this, true);
        this.actionCopyValueToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+C", (IAction)this.actionCopyValueToClipboard);
        this.actionCopyDciName = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M2+C", (IAction)this.actionCopyDciName);
        this.actionForcePoll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRecalculateData = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClearData = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void refresh() {
        this.getDataFromServer(null);
    }

    protected long getDciId(Object dci) {
        return ((DciValue)dci).getId();
    }

    protected long getObjectId(Object dci) {
        return ((DciValue)dci).getNodeId();
    }

    protected String getDciName(Object dci) {
        return ((DciValue)dci).getName();
    }

    protected boolean showDCIPropertyPages(DataCollectionObject object) {
        boolean hasClusterParent;
        DataCollectionObjectEditor dce = new DataCollectionObjectEditor(object);
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(dce)));
        boolean bl = hasClusterParent = this.getObject().getAllParents(14).size() > 0;
        if (this.getObject() instanceof Cluster || this.getObject() instanceof Template || hasClusterParent) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("clisterOptions", (IPreferencePage)new ClusterOptions(dce)));
        }
        pm.addToRoot((IPreferenceNode)new PreferenceNode("customSchedule", (IPreferencePage)new CustomSchedule(dce)));
        if (dce.getObject() instanceof DataCollectionTable) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("columns", (IPreferencePage)new TableColumns(dce)));
        }
        pm.addToRoot((IPreferenceNode)new PreferenceNode("transformation", (IPreferencePage)new Transformation(dce)));
        if (dce.getObject() instanceof DataCollectionItem) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("thresholds", (IPreferencePage)new Thresholds(dce)));
        } else {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("thresholds", (IPreferencePage)new TableThresholds(dce)));
        }
        pm.addToRoot((IPreferenceNode)new PreferenceNode("instanceDiscovery", (IPreferencePage)new InstanceDiscovery(dce)));
        if (dce.getObject() instanceof DataCollectionItem) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("performanceTab", (IPreferencePage)new PerformanceView(dce)));
        }
        pm.addToRoot((IPreferenceNode)new PreferenceNode("accessControl", (IPreferencePage)new AccessControl(dce)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("snmp", (IPreferencePage)new SNMP(dce)));
        if (dce.getObject() instanceof DataCollectionItem) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("winperf", (IPreferencePage)new WinPerf(dce)));
        }
        if (dce.getObject() instanceof DataCollectionItem) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("otherOptions", (IPreferencePage)new OtherOptions(dce)));
        } else {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("otherOptions", (IPreferencePage)new OtherOptionsTable(dce)));
        }
        pm.addToRoot((IPreferenceNode)new PreferenceNode("comments", (IPreferencePage)new Comments(dce)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, String.format(this.i18n.tr("Properties for %s"), object.getName()));
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    protected AbstractViewerFilter createFilter() {
        return new LastValuesFilter();
    }

    protected void postLastValueViewCreation(String configPrefix, VisibilityValidator validator) {
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        PreferenceStore ds = PreferenceStore.getInstance();
        this.refreshController = new ViewRefreshController((View)this, -1, (Runnable)new /* Unavailable Anonymous Inner Class!! */, validator);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.autoRefreshInterval = ds.getAsInteger(configPrefix + ".autoRefreshInterval", this.autoRefreshInterval);
        this.setAutoRefreshEnabled(ds.getAsBoolean(configPrefix + ".autoRefresh", true));
        this.labelProvider.setUseMultipliers(ds.getAsBoolean(configPrefix + ".useMultipliers", true));
        boolean showErrors = ds.getAsBoolean(configPrefix + ".showErrors", true);
        this.labelProvider.setShowErrors(showErrors);
        this.comparator.setShowErrors(showErrors);
        this.lvFilter.setShowDisabled(ds.getAsBoolean(configPrefix + ".showDisabled", false));
        this.lvFilter.setShowUnsupported(ds.getAsBoolean(configPrefix + ".showUnsupported", false));
        this.lvFilter.setShowHidden(ds.getAsBoolean(configPrefix + ".showHidden", false));
        this.createContextMenu();
        if (validator == null || validator.isVisible()) {
            this.getDataFromServer(null);
        }
    }

    protected void getDataFromServer(Runnable callback) {
        if (this.getObject() == null) {
            this.viewer.setInput((Object)new DciValue[0]);
            return;
        }
        DataCollectionTarget jobTarget = (DataCollectionTarget)this.getObject();
        17 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
        this.refreshController.setInterval(autoRefreshEnabled ? this.autoRefreshInterval : -1);
    }

    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    public boolean areMultipliersUsed() {
        return this.labelProvider != null ? this.labelProvider.areMultipliersUsed() : false;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        if (this.labelProvider != null) {
            this.labelProvider.setUseMultipliers(useMultipliers);
            if (this.viewer != null) {
                this.viewer.refresh(true);
            }
        }
    }

    public boolean isShowErrors() {
        return this.labelProvider != null ? this.labelProvider.isShowErrors() : false;
    }

    public void setShowErrors(boolean show) {
        this.labelProvider.setShowErrors(show);
        this.comparator.setShowErrors(show);
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    public boolean isShowDisabled() {
        return this.lvFilter != null ? this.lvFilter.isShowDisabled() : false;
    }

    public void setShowDisabled(boolean show) {
        this.lvFilter.setShowDisabled(show);
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    public boolean isShowUnsupported() {
        return this.lvFilter != null ? this.lvFilter.isShowUnsupported() : false;
    }

    public void setShowUnsupported(boolean show) {
        this.lvFilter.setShowUnsupported(show);
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    public boolean isShowHidden() {
        return this.lvFilter != null ? this.lvFilter.isShowHidden() : false;
    }

    public void setShowHidden(boolean show) {
        this.lvFilter.setShowHidden(show);
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    private void onDoubleClick() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object dcObject = selection.getFirstElement();
        if (dcObject instanceof DataCollectionTable || dcObject instanceof DciValue && ((DciValue)dcObject).getDcObjectType() == 2) {
            this.openView((View)new TableLastValuesView(this.getObject(), this.getObjectId(dcObject), this.getDciId(dcObject)));
        } else {
            ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>(1);
            items.add(this.getConfigFromObject(dcObject));
            this.openView((View)new HistoricalGraphView(this.getObject(), items, null, 0L));
        }
    }

    protected ChartDciConfig getConfigFromObject(Object o) {
        return new ChartDciConfig((DciValue)o);
    }

    private void copySelection() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        String nl = WidgetHelper.getNewLineCharacters();
        StringBuilder sb = new StringBuilder();
        for (Object o : selection.toList()) {
            if (sb.length() > 0) {
                sb.append(nl);
            }
            DciValue v = (DciValue)o;
            sb.append(v.getDescription());
            sb.append(" = ");
            sb.append(v.getValue());
        }
        if (selection.size() > 1) {
            sb.append(nl);
        }
        WidgetHelper.copyToClipboard((String)sb.toString());
    }

    private void copySelectionDciName() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        StringBuilder dciName = new StringBuilder();
        for (Object o : selection.toList()) {
            if (dciName.length() > 0) {
                dciName.append(' ');
            }
            dciName.append(this.getDciName(o));
        }
        WidgetHelper.copyToClipboard((String)dciName.toString());
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof DataCollectionTarget;
    }

    public int getPriority() {
        return 30;
    }

    public int getDciSelectionType() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return 0;
        }
        boolean isDci = false;
        boolean isTable = false;
        for (Object dcObject : selection.toList()) {
            if (dcObject instanceof DataCollectionTable || dcObject instanceof DciValue && ((DciValue)dcObject).getDcObjectType() == 2) {
                isTable = true;
                continue;
            }
            isDci = true;
        }
        return isTable & isDci ? 0 : (isTable ? 2 : 1);
    }

    private void forcePoll() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<Pair> dciList = new ArrayList<Pair>();
        for (Object dci : selection.toList()) {
            dciList.add(new Pair((Object)this.getObjectId(dci), (Object)this.getDciId(dci)));
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void startDataRecalculation() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)"Start Data Recalculation", (String)"Collected values will be re-calculated using stored raw values and current transformation settings. Continue?")) {
            return;
        }
        ArrayList<Pair> dciList = new ArrayList<Pair>();
        for (Object dci : selection.toList()) {
            dciList.add(new Pair((Object)this.getObjectId(dci), (Object)this.getDciId(dci)));
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void clearCollectedData() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)"Clear Collected Data", (String)"All collected data for selected data collection items will be deleted. Proceed?")) {
            return;
        }
        ArrayList<Pair> dciList = new ArrayList<Pair>();
        for (Object dci : selection.toList()) {
            dciList.add(new Pair((Object)this.getObjectId(dci), (Object)this.getDciId(dci)));
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    static /* synthetic */ NXCSession access$000(BaseDataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(BaseDataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(BaseDataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(BaseDataCollectionView x0) {
        return x0.session;
    }
}

