/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ClusterOptions
extends AbstractDCIPropertyPage {
    private AbstractObject owner;
    private Cluster cluster = null;
    private Combo clusterResource;
    private Map<Integer, Long> clusterResourceMap;
    private Button checkAggregate;
    private Button checkAggregateWithErrors;
    private Button checkRunScript;
    private Combo aggregationFunction;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        NXCSession session = ConsoleSharedData.getSession();
        this.owner = session.findObjectById(this.editor.getObject().getNodeId());
        if (this.owner instanceof Cluster) {
            this.cluster = (Cluster)this.owner;
        } else if (this.owner instanceof AbstractNode) {
            AbstractObject[] abstractObjectArray = this.owner.getParentsAsArray();
            int n = abstractObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractObject o = abstractObjectArray[n2];
                if (o instanceof Cluster) {
                    this.cluster = (Cluster)o;
                    break;
                }
                ++n2;
            }
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.clusterResource = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.General_ClRes, (Object)"WidgetHelper::default_layout_data");
        if (this.cluster != null) {
            this.clusterResourceMap = new HashMap<Integer, Long>();
            this.clusterResourceMap.put(0, 0L);
            Messages.get();
            this.clusterResource.add(Messages.General_None);
            if (this.editor.getObject().getResourceId() == 0L) {
                this.clusterResource.select(0);
            }
            int index = 1;
            for (ClusterResource r : this.cluster.getResources()) {
                this.clusterResource.add(r.getName());
                this.clusterResourceMap.put(index, r.getId());
                if (this.editor.getObject().getResourceId() == r.getId()) {
                    this.clusterResource.select(index);
                }
                ++index;
            }
        } else {
            Messages.get();
            this.clusterResource.add(Messages.General_None);
            this.clusterResource.select(0);
            this.clusterResource.setEnabled(false);
        }
        Group aggregationGroup = new Group(dialogArea, 0);
        Messages.get();
        aggregationGroup.setText(Messages.ClusterOptions_DataAggregation);
        aggregationGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        aggregationGroup.setLayout((Layout)layout);
        this.checkAggregate = new Button((Composite)aggregationGroup, 32);
        Messages.get();
        this.checkAggregate.setText(Messages.ClusterOptions_AggregateFromNodes);
        this.checkAggregate.setSelection(this.editor.getObject().isAggregateOnCluster());
        this.checkAggregateWithErrors = new Button((Composite)aggregationGroup, 32);
        this.checkAggregateWithErrors.setText("Use last known value for aggregation in case of data collection error");
        this.checkAggregateWithErrors.setSelection(this.editor.getObject().isAggregateWithErrors());
        this.checkRunScript = new Button((Composite)aggregationGroup, 32);
        Messages.get();
        this.checkRunScript.setText(Messages.ClusterOptions_RunScriptOnAggregatedData);
        this.checkRunScript.setSelection(this.editor.getObject().isTransformAggregated());
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.checkAggregate.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ClusterOptions.this.aggregationFunction.setEnabled(ClusterOptions.this.checkAggregate.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Messages.get();
            this.aggregationFunction = WidgetHelper.createLabeledCombo((Composite)aggregationGroup, (int)2056, (String)Messages.ClusterOptions_AggrFunction, (Object)"WidgetHelper::default_layout_data");
            Messages.get();
            this.aggregationFunction.add(Messages.ClusterOptions_Total);
            Messages.get();
            this.aggregationFunction.add(Messages.ClusterOptions_Average);
            Messages.get();
            this.aggregationFunction.add(Messages.ClusterOptions_Min);
            Messages.get();
            this.aggregationFunction.add(Messages.ClusterOptions_Max);
            this.aggregationFunction.select(this.editor.getObjectAsItem().getAggregationFunction());
            this.aggregationFunction.setEnabled(this.editor.getObjectAsItem().isAggregateOnCluster());
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.cluster != null) {
            this.editor.getObject().setResourceId(this.clusterResourceMap.get(this.clusterResource.getSelectionIndex()).longValue());
        }
        this.editor.getObject().setAggregateOnCluster(this.checkAggregate.getSelection());
        this.editor.getObject().setAggregateWithErrors(this.checkAggregateWithErrors.getSelection());
        this.editor.getObject().setTransformAggregated(this.checkRunScript.getSelection());
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.editor.getObjectAsItem().setAggregationFunction(this.aggregationFunction.getSelectionIndex());
        }
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.clusterResource.select(0);
        this.checkAggregate.setSelection(false);
        this.aggregationFunction.select(0);
        this.aggregationFunction.setEnabled(false);
    }
}

