/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.ClusterResource;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.objecttabs.helpers.ClusterResourceMapElement;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;

public class ResourceFigure
extends Figure {
    private static final int IMAGE_SIZE_X = 48;
    private static final int IMAGE_SIZE_Y = 48;
    private static final int IMAGE_MARGIN_X = 12;
    private static final int IMAGE_MARGIN_Y = 4;
    private static final int BACKGROUND_MARGIN_X = 4;
    private static final int BACKGROUND_MARGIN_Y = 4;
    private static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 132, 0, 200);
    private ClusterResourceMapElement element;
    private MapLabelProvider labelProvider;
    private Label label;

    public ResourceFigure(ClusterResourceMapElement element, MapLabelProvider labelProvider) {
        this.element = element;
        this.labelProvider = labelProvider;
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.label = new Label(this.getElementName());
        this.label.setFont(labelProvider.getLabelFont());
        this.label.setLabelAlignment(2);
        this.add((IFigure)this.label, BorderLayout.BOTTOM);
        Dimension ls = this.label.getPreferredSize(72, -1);
        this.setSize(72, 56 + ls.height);
        this.setFocusTraversable(true);
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        org.eclipse.draw2d.geometry.Rectangle rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        if (this.labelProvider.isShowStatusBackground()) {
            rect.x += 8;
            rect.y += 0;
            rect.width = 56;
            rect.height = 56;
            gc.setBackgroundColor(StatusDisplayInfo.getStatusColor((ObjectStatus)this.getElementStatus()));
            gc.setAlpha(64);
            gc.fillRoundRectangle(rect, 16, 16);
            gc.setAlpha(255);
            rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        }
        if (this.labelProvider.isShowStatusFrame()) {
            rect.x += 8;
            ++rect.y;
            rect.width = 56;
            rect.height = 55;
            gc.setForegroundColor(StatusDisplayInfo.getStatusColor((ObjectStatus)this.getElementStatus()));
            gc.setLineWidth(3);
            gc.setLineStyle(this.labelProvider.isElementSelected(this.element) ? 3 : 1);
            gc.drawRoundRectangle(rect, 16, 16);
            rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        } else if (this.labelProvider.isElementSelected(this.element)) {
            rect.x += 8;
            ++rect.y;
            rect.width = 56;
            rect.height = 55;
            gc.setForegroundColor(SELECTION_COLOR);
            gc.setLineWidth(3);
            gc.setLineStyle(this.labelProvider.isElementSelected(this.element) ? 3 : 1);
            gc.drawRoundRectangle(rect, 16, 16);
            rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        }
        Image image = this.labelProvider.getImage((Object)this.element);
        if (image != null) {
            gc.drawImage(image, rect.x + 12, rect.y + 4);
        }
        if (this.labelProvider.isShowStatusIcons() && (image = StatusDisplayInfo.getStatusImage((ObjectStatus)this.getElementStatus())) != null) {
            Rectangle imgSize = image.getBounds();
            gc.drawImage(image, rect.x + rect.width - imgSize.width, rect.y);
        }
    }

    void update() {
        this.label.setText(this.getElementName());
        this.invalidateTree();
    }

    private String getElementName() {
        return ((ClusterResource)this.element.getData()).getName();
    }

    private ObjectStatus getElementStatus() {
        return ((ClusterResource)this.element.getData()).getCurrentOwner() == 0L ? ObjectStatus.MAJOR : ObjectStatus.NORMAL;
    }
}

