/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectScriptDialog
extends Dialog {
    private TableViewer viewer;
    private List<Script> selection = new ArrayList<Script>(0);
    private boolean multiSelection = false;

    public SelectScriptDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        Messages.get();
        newShell.setText(Messages.SelectScriptDialog_Title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.SelectScriptDialog_AvailableScripts);
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Script)element).getName();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Script s1 = (Script)e1;
                Script s2 = (Script)e2;
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectScriptDialog.this.okPressed();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SelectScriptDialog_JobTitle, null, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List scripts = session.getScriptLibrary();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).SelectScriptDialog.this.viewer.setInput((Object)scripts.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectScriptDialog_JobError;
            }
        }.start();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (s.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectScriptDialog_Warning, (String)Messages.SelectScriptDialog_WarningEmptySelection);
            return;
        }
        for (Object o : s.toList()) {
            this.selection.add((Script)o);
        }
        super.okPressed();
    }

    public Script getScript() {
        return this.selection.size() > 0 ? this.selection.get(0) : null;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public List<Script> getSelection() {
        return this.selection;
    }
}

