/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImageSelector;
import org.netxms.nxmc.modules.objects.propertypages.MapBackground;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class MapBackground
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(MapBackground.class);
    private NetworkMap map;
    private LabeledSpinner width;
    private LabeledSpinner height;
    private Button fitToScreen;
    private Button radioTypeNone;
    private Button radioTypeImage;
    private Button radioTypeGeoMap;
    private ImageSelector image;
    private LabeledCombo comboImageFit;
    private LabeledText latitude;
    private LabeledText longitude;
    private Scale zoomScale;
    private Spinner zoomSpinner;
    private Label zoomLabel;
    private ColorSelector backgroundColor;
    private boolean disableGeolocationBackground;

    public MapBackground(AbstractObject object) {
        super(LocalizationHelper.getI18n(MapBackground.class).tr("Map Background"), object);
    }

    public String getId() {
        return "mapBackground";
    }

    public boolean isVisible() {
        return this.object instanceof NetworkMap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.map = (NetworkMap)this.object;
        PreferenceStore settings = PreferenceStore.getInstance();
        this.disableGeolocationBackground = settings.getAsBoolean("DISABLE_GEOLOCATION_BACKGROUND", false);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        Group sizeGroup = new Group(dialogArea, 0);
        sizeGroup.setText(this.i18n.tr("Map size"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        sizeGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        sizeGroup.setLayout((Layout)layout);
        this.fitToScreen = new Button((Composite)sizeGroup, 32);
        this.fitToScreen.setText("Fit to scrren");
        this.fitToScreen.setSelection(this.map.isFitToScreen());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.fitToScreen.setLayoutData((Object)gd);
        this.fitToScreen.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.width = new LabeledSpinner((Composite)sizeGroup, 0);
        this.width.setRange(0, Integer.MAX_VALUE);
        this.width.setLabel(this.i18n.tr("Width"));
        this.width.setSelection(this.map.getWidth());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.width.setLayoutData((Object)gd);
        this.width.setEnabled(!this.fitToScreen.getSelection());
        this.height = new LabeledSpinner((Composite)sizeGroup, 0);
        this.height.setRange(0, Integer.MAX_VALUE);
        this.height.setLabel(this.i18n.tr("Height"));
        this.height.setSelection(this.map.getHeight());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.height.setLayoutData((Object)gd);
        this.height.setEnabled(!this.fitToScreen.getSelection());
        Group typeGroup = new Group(dialogArea, 0);
        typeGroup.setText(this.i18n.tr("Background type"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        typeGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        typeGroup.setLayout((Layout)layout);
        2 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioTypeNone = new Button((Composite)typeGroup, 16);
        this.radioTypeNone.setText(this.i18n.tr("&None"));
        this.radioTypeNone.setSelection(this.map.getBackground().equals(NXCommon.EMPTY_GUID));
        this.radioTypeNone.addSelectionListener((SelectionListener)listener);
        this.radioTypeImage = new Button((Composite)typeGroup, 16);
        this.radioTypeImage.setText(this.i18n.tr("&Image"));
        this.radioTypeImage.setSelection(!this.map.getBackground().equals(NXCommon.EMPTY_GUID) && !this.map.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND));
        this.radioTypeImage.addSelectionListener((SelectionListener)listener);
        if (!this.disableGeolocationBackground) {
            this.radioTypeGeoMap = new Button((Composite)typeGroup, 16);
            this.radioTypeGeoMap.setText(this.i18n.tr("&Geographic Map"));
            this.radioTypeGeoMap.setSelection(this.map.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND));
            this.radioTypeGeoMap.addSelectionListener((SelectionListener)listener);
        } else if (this.map.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
            this.radioTypeNone.setSelection(true);
        }
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel(this.i18n.tr("Background image"));
        if (this.radioTypeImage.getSelection()) {
            this.image.setImageGuid(this.map.getBackground(), true);
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.image.setLayoutData((Object)gd);
        this.comboImageFit = new LabeledCombo(dialogArea, 0);
        this.comboImageFit.setLabel("Image fit");
        this.comboImageFit.add("Default");
        this.comboImageFit.add("Center");
        this.comboImageFit.add("Fit");
        if (this.map.isCenterBackgroundImage()) {
            this.comboImageFit.select(1);
        } else if (this.map.isFitBackgroundImage()) {
            this.comboImageFit.select(2);
        } else {
            this.comboImageFit.select(0);
        }
        if (!this.disableGeolocationBackground) {
            Group geomapGroup = new Group(dialogArea, 0);
            geomapGroup.setText(this.i18n.tr("Geographic map"));
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            geomapGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            geomapGroup.setLayout((Layout)layout);
            GeoLocation gl = this.map.getBackgroundLocation();
            this.latitude = new LabeledText((Composite)geomapGroup, 0);
            this.latitude.setLabel(this.i18n.tr("Latitude"));
            this.latitude.setText(gl.getLatitudeAsString());
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.latitude.setLayoutData((Object)gd);
            this.longitude = new LabeledText((Composite)geomapGroup, 0);
            this.longitude.setLabel(this.i18n.tr("Longitude"));
            this.longitude.setText(gl.getLongitudeAsString());
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.longitude.setLayoutData((Object)gd);
            Composite zoomGroup = new Composite((Composite)geomapGroup, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.horizontalSpacing = 4;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            zoomGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            zoomGroup.setLayoutData((Object)gd);
            this.zoomLabel = new Label(zoomGroup, 0);
            this.zoomLabel.setText(this.i18n.tr("Zoom level"));
            gd = new GridData();
            gd.horizontalAlignment = 16384;
            gd.horizontalSpan = 2;
            this.zoomLabel.setLayoutData((Object)gd);
            this.zoomScale = new Scale(zoomGroup, 256);
            this.zoomScale.setMinimum(1);
            this.zoomScale.setMaximum(18);
            this.zoomScale.setSelection(this.map.getBackgroundZoom());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.zoomScale.setLayoutData((Object)gd);
            this.zoomScale.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.zoomSpinner = new Spinner(zoomGroup, 2048);
            this.zoomSpinner.setMinimum(1);
            this.zoomSpinner.setMaximum(18);
            this.zoomSpinner.setSelection(this.map.getBackgroundZoom());
            this.zoomSpinner.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        Composite colorArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginWidth = 0;
        colorArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        colorArea.setLayoutData((Object)gd);
        Label label = new Label(colorArea, 0);
        label.setText(this.i18n.tr("Background color:"));
        this.backgroundColor = new ColorSelector(colorArea);
        this.backgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.map.getBackgroundColor()));
        this.enableControls(this.radioTypeImage.getSelection(), this.disableGeolocationBackground ? false : this.radioTypeGeoMap.getSelection());
        return dialogArea;
    }

    private void enableControls(boolean imageGroup, boolean geoGroup) {
        this.image.setEnabled(imageGroup);
        if (!this.disableGeolocationBackground) {
            this.latitude.setEnabled(geoGroup);
            this.longitude.setEnabled(geoGroup);
            this.zoomLabel.setEnabled(geoGroup);
            this.zoomScale.setEnabled(geoGroup);
            this.zoomSpinner.setEnabled(geoGroup);
        }
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        if (this.fitToScreen.getSelection()) {
            md.setObjectFlags(4096, 4096);
        } else {
            md.setObjectFlags(0, 4096);
            md.setMapSize(this.width.getSelection(), this.height.getSelection());
        }
        if (this.radioTypeNone.getSelection()) {
            md.setMapBackground(NXCommon.EMPTY_GUID, new GeoLocation(false), 0, ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
        } else if (this.radioTypeImage.getSelection()) {
            md.setMapBackground(this.image.getImageGuid(), new GeoLocation(false), 0, ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
            if (this.comboImageFit.getSelectionIndex() == 1) {
                md.setObjectFlags(256, 2304);
            } else if (this.comboImageFit.getSelectionIndex() == 2) {
                md.setObjectFlags(2048, 2304);
            } else {
                md.setObjectFlags(0, 2304);
            }
        } else if (!this.disableGeolocationBackground && this.radioTypeGeoMap.getSelection()) {
            GeoLocation location;
            try {
                location = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            }
            catch (GeoLocationFormatException e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Geolocation format error"));
                return false;
            }
            md.setMapBackground(NetworkMap.GEOMAP_BACKGROUND, location, this.zoomSpinner.getSelection(), ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

