/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.packages.PackageInfo;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.dialogs.PackageSelectionDialog;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.PackageComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.PackageLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class PackageSelectionDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(PackageSelectionDialog.class);
    private SortableTableViewer packageList;
    private long packageId;

    public PackageSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Package"));
        PreferenceStore ps = PreferenceStore.getInstance();
        newShell.setSize(ps.getAsInteger("PackageSelectionDialog.w", 700), ps.getAsInteger("PackageSelectionDialog.h", 400));
        newShell.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Version"), this.i18n.tr("Platform"), this.i18n.tr("File"), "Command", this.i18n.tr("Description")};
        int[] widths = new int[]{70, 120, 100, 90, 120, 300, 300, 400};
        this.packageList = new SortableTableViewer(dialogArea, names, widths, 0, 128, 65538);
        this.packageList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.packageList.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.packageList.setComparator((ViewerComparator)new PackageComparator());
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.fetchPackageList();
        return content;
    }

    private void fetchPackageList() {
        this.packageList.setInput((Object)new String[]{"Loading..."});
        this.getButton(0).setEnabled(false);
        NXCSession session = Registry.getSession();
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void okPressed() {
        IStructuredSelection selection = this.packageList.getStructuredSelection();
        if (selection.size() != 1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You must select one package from the list and then press OK."));
            return;
        }
        this.packageId = ((PackageInfo)selection.getFirstElement()).getId();
        super.okPressed();
    }

    public long getSelectedPackageId() {
        return this.packageId;
    }

    static /* synthetic */ Button access$000(PackageSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

