/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.MacAddress;
import org.netxms.client.constants.SensorDeviceClass;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.MacAddressValidator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ObjectNameValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledCombo;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateSensorDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText aliasField;
    private LabeledText macAddrField;
    private LabeledCombo deviceClassField;
    private ObjectSelector gatewayNodeField;
    private LabeledText deviceAddressField;
    private LabeledSpinner modbusUnitIdField;
    private LabeledText vendorField;
    private LabeledText modelField;
    private LabeledText serialNumberField;
    private String name;
    private String alias;
    private SensorDeviceClass deviceClass;
    private MacAddress macAddress;
    private String deviceAddress;
    private long gatewayNodeId;
    private short modbusUnitId;
    private String vendor;
    private String model;
    private String serialNumber;

    public CreateSensorDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Sensor");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name");
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel("Alias");
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.aliasField.setLayoutData((Object)gd);
        this.deviceClassField = new LabeledCombo(dialogArea, 0);
        this.deviceClassField.setLabel("Device class");
        this.deviceClassField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Locale locale = Locale.getDefault();
        SensorDeviceClass[] sensorDeviceClassArray = (SensorDeviceClass[])SensorDeviceClass.class.getEnumConstants();
        int n = sensorDeviceClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SensorDeviceClass c = sensorDeviceClassArray[n2];
            this.deviceClassField.add(c.getDisplayName(locale));
            ++n2;
        }
        this.deviceClassField.select(0);
        this.gatewayNodeField = new ObjectSelector(dialogArea, 0, true);
        this.gatewayNodeField.setLabel("Gateway node");
        this.gatewayNodeField.setObjectClass(Node.class);
        this.gatewayNodeField.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        this.gatewayNodeField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.macAddrField = new LabeledText(dialogArea, 0);
        this.macAddrField.setLabel("MAC address");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.macAddrField.setLayoutData((Object)gd);
        this.modbusUnitIdField = new LabeledSpinner(dialogArea, 0);
        this.modbusUnitIdField.setLabel("Modbus unit ID");
        this.modbusUnitIdField.setRange(0, 255);
        this.modbusUnitIdField.setSelection(255);
        this.deviceAddressField = new LabeledText(dialogArea, 0);
        this.deviceAddressField.setLabel("Device address");
        this.deviceAddressField.getTextControl().setTextLimit(255);
        this.deviceAddressField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.vendorField = new LabeledText(dialogArea, 0);
        this.vendorField.setLabel("Vendor");
        this.vendorField.getTextControl().setTextLimit(255);
        this.vendorField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.modelField = new LabeledText(dialogArea, 0);
        this.modelField.setLabel("Model");
        this.modelField.getTextControl().setTextLimit(255);
        this.modelField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.serialNumberField = new LabeledText(dialogArea, 0);
        this.serialNumberField.setLabel("Serial number");
        this.serialNumberField.getTextControl().setTextLimit(63);
        this.serialNumberField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        if (!WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator()) || !WidgetHelper.validateTextInput((LabeledText)this.macAddrField, (TextFieldValidator)new MacAddressValidator(true))) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        try {
            this.name = this.nameField.getText().trim();
            this.alias = this.aliasField.getText().trim();
            this.deviceClass = SensorDeviceClass.getByValue((int)this.deviceClassField.getSelectionIndex());
            this.gatewayNodeId = this.gatewayNodeField.getObjectId();
            this.macAddress = this.macAddrField.getText().trim().isEmpty() ? new MacAddress() : MacAddress.parseMacAddress((String)this.macAddrField.getText());
            this.modbusUnitId = (short)this.modbusUnitIdField.getSelection();
            this.deviceAddress = this.deviceAddressField.getText().trim();
            this.vendor = this.vendorField.getText().trim();
            this.model = this.modelField.getText().trim();
            this.serialNumber = this.serialNumberField.getText().trim();
            super.okPressed();
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Internal error: %s", e.getLocalizedMessage()));
            WidgetHelper.adjustWindowSize((Window)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public SensorDeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public long getGatewayNodeId() {
        return this.gatewayNodeId;
    }

    public short getModbusUnitId() {
        return this.modbusUnitId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }
}

