/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.actions;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class UploadFileToServer
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.window.getShell());
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            List<File> fileList = dlg.getLocalFiles();
            int i = 0;
            while (i < fileList.size()) {
                final File localFile = fileList.get(i);
                String tmp = fileList.get(i).getName();
                if (fileList.size() == 1) {
                    tmp = dlg.getRemoteFileName();
                }
                final String remoteFile = tmp;
                Messages.get();
                new ConsoleJob(Messages.UploadFileToServer_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

                    protected void runInternal(final IProgressMonitor monitor) throws Exception {
                        session.uploadFileToServer(localFile, remoteFile, new ProgressListener(){
                            private long prevWorkDone = 0L;

                            public void setTotalWorkAmount(long workTotal) {
                                Messages.get();
                                monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + localFile.getAbsolutePath(), (int)workTotal);
                            }

                            public void markProgress(long workDone) {
                                monitor.worked((int)(workDone - this.prevWorkDone));
                                this.prevWorkDone = workDone;
                            }
                        });
                        monitor.done();
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return Messages.UploadFileToServer_JobError;
                    }
                }.start();
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

