/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;

public class JsonViewer
extends Composite {
    private StyledText textControl;
    private Color colorBuiltin = ThemeEngine.getForegroundColor("JSON.Builtin");
    private Color colorKey = ThemeEngine.getForegroundColor("JSON.Key");
    private Color colorNumber = ThemeEngine.getForegroundColor("JSON.Number");
    private Color colorString = ThemeEngine.getForegroundColor("JSON.String");

    public JsonViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.textControl = new StyledText((Composite)this, 778);
        this.textControl.setFont(JFaceResources.getTextFont());
        this.textControl.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                try {
                    event.styles = JsonViewer.this.styleLine(event.lineText);
                    if (event.styles != null) {
                        StyleRange[] styleRangeArray = event.styles;
                        int n = event.styles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StyleRange r = styleRangeArray[n2];
                            r.start += event.lineOffset;
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    Activator.logError("Exception in line style listener", e);
                }
            }
        });
    }

    private StyleRange[] styleLine(String line) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(8);
        int state = 0;
        int start = 0;
        char[] chars = line.toCharArray();
        int pos = 0;
        while (pos < chars.length) {
            switch (state) {
                case 0: {
                    if (chars[pos] == '\"') {
                        state = 1;
                        start = pos;
                        break;
                    }
                    if (chars[pos] >= '0' && chars[pos] <= '9') {
                        state = 3;
                        start = pos;
                        break;
                    }
                    if (chars[pos] == 't' && line.substring(pos, pos + 4).equals("true") || chars[pos] == 'f' && line.substring(pos, pos + 5).equals("false") || chars[pos] == 'n' && line.substring(pos, pos + 4).equals("null")) {
                        state = 4;
                        start = pos;
                        pos += chars[pos] == 'f' ? 4 : 3;
                        break;
                    }
                    if (chars[pos] != '{' && chars[pos] != '}' && chars[pos] != '[' && chars[pos] != ']') break;
                    ranges.add(new StyleRange(pos, 1, null, null, 1));
                    break;
                }
                case 1: {
                    if (chars[pos] == '\\') {
                        state = 2;
                        break;
                    }
                    if (chars[pos] != '\"') break;
                    state = 0;
                    Color color = pos < chars.length - 1 && chars[pos + 1] == ':' ? this.colorKey : this.colorString;
                    ranges.add(new StyleRange(start, pos - start + 1, color, null));
                    break;
                }
                case 2: {
                    state = 1;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace(chars[pos]) || chars[pos] == ',' || chars[pos] == ']' || chars[pos] == '}') {
                        ranges.add(new StyleRange(start, pos - start, this.colorNumber, null));
                        state = 0;
                        --pos;
                        break;
                    }
                    if (chars[pos] >= '0' && chars[pos] <= '9') break;
                    state = 0;
                    break;
                }
                case 4: {
                    if (Character.isWhitespace(chars[pos]) || chars[pos] == ',' || chars[pos] == ']' || chars[pos] == '}') {
                        ranges.add(new StyleRange(start, pos - start, this.colorBuiltin, null, 1));
                        --pos;
                    }
                    state = 0;
                    break;
                }
            }
            ++pos;
        }
        if (state == 3) {
            ranges.add(new StyleRange(start, chars.length - start, this.colorNumber, null));
        } else if (state == 4) {
            ranges.add(new StyleRange(start, chars.length - start, this.colorBuiltin, null, 1));
        }
        return !ranges.isEmpty() ? (StyleRange[])ranges.toArray(StyleRange[]::new) : null;
    }

    public void setContent(String jsonText, boolean prettify) {
        if (prettify) {
            if (!(jsonText = jsonText.trim()).startsWith("{") && !jsonText.startsWith("[")) {
                jsonText = "{" + jsonText + "}";
            }
            Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
            JsonElement json = (JsonElement)gson.fromJson(jsonText, JsonElement.class);
            jsonText = gson.toJson(json);
        }
        this.textControl.setText(jsonText);
    }
}

