/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class SparkleDigest
implements Digest {
    private String algorithmName;
    private final int[] state;
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final int DIGEST_BYTES;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int STATE_BRANS;
    private final int STATE_WORDS;
    private final int RATE_WORDS;
    private final int RATE_BYTES;
    private static final int[] RCON = new int[]{-1209970334, -1083090816, 951376470, 844003128, -1156479509, 1333558103, -809524792, -1028445891};

    public SparkleDigest(SparkleParameters sparkleParameters) {
        int n;
        int n2;
        int n3 = 128;
        switch (sparkleParameters) {
            case ESCH256: {
                n2 = 256;
                n = 384;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "ESCH-256";
                break;
            }
            case ESCH384: {
                n2 = 384;
                n = 512;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.algorithmName = "ESCH-384";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.STATE_BRANS = n >>> 6;
        this.STATE_WORDS = n >>> 5;
        this.RATE_WORDS = n3 >>> 5;
        this.RATE_BYTES = n3 >>> 3;
        this.DIGEST_BYTES = n2 >>> 3;
        this.state = new int[this.STATE_WORDS];
    }

    private int ROT(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private int ELL(int n) {
        return this.ROT(n ^ n << 16, 16);
    }

    private void sparkle_opt(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5;
            nArray[1] = nArray[1] ^ RCON[i & 7];
            nArray[3] = nArray[3] ^ i;
            for (n5 = 0; n5 < 2 * n; n5 += 2) {
                int n6 = RCON[n5 >>> 1];
                int n7 = n5;
                nArray[n7] = nArray[n7] + this.ROT(nArray[n5 + 1], 31);
                int n8 = n5 + 1;
                nArray[n8] = nArray[n8] ^ this.ROT(nArray[n5], 24);
                int n9 = n5;
                nArray[n9] = nArray[n9] ^ n6;
                int n10 = n5;
                nArray[n10] = nArray[n10] + this.ROT(nArray[n5 + 1], 17);
                int n11 = n5 + 1;
                nArray[n11] = nArray[n11] ^ this.ROT(nArray[n5], 17);
                int n12 = n5;
                nArray[n12] = nArray[n12] ^ n6;
                int n13 = n5;
                nArray[n13] = nArray[n13] + nArray[n5 + 1];
                int n14 = n5 + 1;
                nArray[n14] = nArray[n14] ^ this.ROT(nArray[n5], 31);
                int n15 = n5;
                nArray[n15] = nArray[n15] ^ n6;
                int n16 = n5;
                nArray[n16] = nArray[n16] + this.ROT(nArray[n5 + 1], 24);
                int n17 = n5 + 1;
                nArray[n17] = nArray[n17] ^ this.ROT(nArray[n5], 16);
                int n18 = n5;
                nArray[n18] = nArray[n18] ^ n6;
            }
            int n19 = n4 = nArray[0];
            int n20 = n3 = nArray[1];
            for (n5 = 2; n5 < n; n5 += 2) {
                n19 ^= nArray[n5];
                n20 ^= nArray[n5 + 1];
            }
            n19 = this.ELL(n19);
            n20 = this.ELL(n20);
            for (n5 = 2; n5 < n; n5 += 2) {
                nArray[n5 - 2] = nArray[n5 + n] ^ nArray[n5] ^ n20;
                nArray[n5 + n] = nArray[n5];
                nArray[n5 - 1] = nArray[n5 + n + 1] ^ nArray[n5 + 1] ^ n19;
                nArray[n5 + n + 1] = nArray[n5 + 1];
            }
            nArray[n - 2] = nArray[n] ^ n4 ^ n20;
            nArray[n] = n4;
            nArray[n - 1] = nArray[n + 1] ^ n3 ^ n19;
            nArray[n + 1] = n3;
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int getDigestSize() {
        return this.DIGEST_BYTES;
    }

    @Override
    public void update(byte by) {
        this.message.write(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        this.message.write(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        if (n + this.DIGEST_BYTES > byArray.length) {
            throw new OutputLengthException(this.algorithmName + " input buffer too short");
        }
        byte[] byArray2 = this.message.toByteArray();
        int n5 = byArray2.length;
        int n6 = 0;
        int[] nArray = Pack.littleEndianToInt(byArray2, 0, n5 >> 2);
        while (n5 > this.RATE_BYTES) {
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < this.RATE_WORDS; n2 += 2) {
                n4 ^= nArray[n2 + (n6 >> 2)];
                n3 ^= nArray[n2 + 1 + (n6 >> 2)];
            }
            n4 = this.ELL(n4);
            n3 = this.ELL(n3);
            for (n2 = 0; n2 < this.RATE_WORDS; n2 += 2) {
                int n7 = n2;
                this.state[n7] = this.state[n7] ^ (nArray[n2 + (n6 >> 2)] ^ n3);
                int n8 = n2 + 1;
                this.state[n8] = this.state[n8] ^ (nArray[n2 + 1 + (n6 >> 2)] ^ n4);
            }
            for (n2 = this.RATE_WORDS; n2 < this.STATE_WORDS / 2; n2 += 2) {
                int n9 = n2;
                this.state[n9] = this.state[n9] ^ n3;
                int n10 = n2 + 1;
                this.state[n10] = this.state[n10] ^ n4;
            }
            this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            n5 -= this.RATE_BYTES;
            n6 += this.RATE_BYTES;
        }
        int n11 = this.STATE_BRANS - 1;
        this.state[n11] = this.state[n11] ^ (n5 < this.RATE_BYTES ? 0x1000000 : 0x2000000);
        int[] nArray2 = new int[this.RATE_WORDS];
        for (n2 = 0; n2 < n5; ++n2) {
            int n12 = n2 >>> 2;
            nArray2[n12] = nArray2[n12] | (byArray2[n6++] & 0xFF) << ((n2 & 3) << 3);
        }
        if (n5 < this.RATE_BYTES) {
            int n13 = n2 >>> 2;
            nArray2[n13] = nArray2[n13] | 128 << ((n2 & 3) << 3);
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < this.RATE_WORDS; n2 += 2) {
            n4 ^= nArray2[n2];
            n3 ^= nArray2[n2 + 1];
        }
        n4 = this.ELL(n4);
        n3 = this.ELL(n3);
        for (n2 = 0; n2 < this.RATE_WORDS; n2 += 2) {
            int n14 = n2;
            this.state[n14] = this.state[n14] ^ (nArray2[n2] ^ n3);
            int n15 = n2 + 1;
            this.state[n15] = this.state[n15] ^ (nArray2[n2 + 1] ^ n4);
        }
        for (n2 = this.RATE_WORDS; n2 < this.STATE_WORDS / 2; n2 += 2) {
            int n16 = n2;
            this.state[n16] = this.state[n16] ^ n3;
            int n17 = n2 + 1;
            this.state[n17] = this.state[n17] ^ n4;
        }
        this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
        Pack.intToLittleEndian(this.state, 0, this.RATE_WORDS, byArray, n);
        int n18 = this.RATE_BYTES;
        n += this.RATE_BYTES;
        while (n18 < this.DIGEST_BYTES) {
            this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, this.RATE_WORDS, byArray, n);
            n18 += this.RATE_BYTES;
            n += this.RATE_BYTES;
        }
        return this.DIGEST_BYTES;
    }

    @Override
    public void reset() {
        Arrays.fill(this.state, 0);
        this.message.reset();
    }

    public static enum SparkleParameters {
        ESCH256,
        ESCH384;

    }
}

