/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.views;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.widgets.Composite;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.PDFViewer;
import org.netxms.nxmc.resources.ResourceManager;

public class ReportResultView
extends View {
    private static Map<UUID, Integer> instances = new ConcurrentHashMap();
    private UUID renderId;
    private String resultFileUrl;
    private Runnable disposeCallback;

    public ReportResultView(String name, UUID renderId, String resultFileUrl, Runnable disposeCallback) {
        super(name, ResourceManager.getImageDescriptor((String)"icons/object-views/report.png"), "ReportResult." + renderId, false);
        this.renderId = renderId;
        this.resultFileUrl = resultFileUrl;
        this.disposeCallback = disposeCallback;
        Integer n = (Integer)instances.get(renderId);
        instances.put(renderId, n != null ? n + 1 : 1);
    }

    protected ReportResultView() {
        super("", ResourceManager.getImageDescriptor((String)"icons/object-views/report.png"), "ReportResult.null", false);
    }

    public View cloneView() {
        ReportResultView view = (ReportResultView)super.cloneView();
        view.renderId = this.renderId;
        view.resultFileUrl = this.resultFileUrl;
        view.disposeCallback = this.disposeCallback;
        Integer n = (Integer)instances.get(this.renderId);
        instances.put(this.renderId, n != null ? n + 1 : 1);
        return view;
    }

    protected void createContent(Composite parent) {
        new PDFViewer(parent, 0).openUrl(this.resultFileUrl);
    }

    public void dispose() {
        Integer n = (Integer)instances.get(this.renderId);
        if (n == null || n <= 1) {
            instances.remove(this.renderId);
            if (this.disposeCallback != null) {
                this.disposeCallback.run();
            }
        } else {
            instances.put(this.renderId, n - 1);
        }
        super.dispose();
    }
}

