/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.views;

import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ContextDashboardView
extends AbstractDashboardView {
    private final I18n i18n = LocalizationHelper.getI18n(ContextDashboardView.class);
    private Dashboard dashboard;
    private SessionListener clientListener;

    public ContextDashboardView(Dashboard dashboard) {
        super(dashboard.getObjectName(), ResourceManager.getImageDescriptor((String)"icons/object-views/dashboard.png"), "ContextDashboard." + dashboard.getObjectId());
        this.dashboard = dashboard;
    }

    protected ContextDashboardView() {
        super(LocalizationHelper.getI18n(ContextDashboardView.class).tr("Dashbaord"), ResourceManager.getImageDescriptor((String)"icons/object-views/dashboard.png"), null);
    }

    public View cloneView() {
        ContextDashboardView view = (ContextDashboardView)super.cloneView();
        view.dashboard = this.dashboard;
        return view;
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && ((AbstractObject)context).hasDashboard(this.dashboard.getObjectId());
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.clientListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.clientListener);
    }

    protected void rebuildCurrentDashboard() {
        this.rebuildDashboard(this.dashboard, this.getObject());
    }

    protected void onObjectChange(AbstractObject object) {
        this.rebuildDashboard(this.dashboard, object);
    }

    public int getPriority() {
        return this.dashboard.getDisplayPriority() > 0 ? this.dashboard.getDisplayPriority() : super.getPriority();
    }

    public void dispose() {
        this.session.removeListener(this.clientListener);
        super.dispose();
    }

    public void saveState(Memento memento) {
        memento.set("dashboard", this.dashboard.getObjectId());
        super.saveState(memento);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        this.dashboard = (Dashboard)this.session.findObjectById(memento.getAsLong("dashboard", 0L), Dashboard.class);
        if (this.dashboard == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid dashboard id"));
        }
        this.setName(this.dashboard.getObjectName());
        super.restoreState(memento);
    }
}

