/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import fr.brouillard.oss.commonmark.ext.notifications.NotificationsExtension;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.footnotes.FootnotesExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.ext.task.list.items.TaskListItemsExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.tools.WidgetHelper;

public class MarkdownViewer
extends Composite {
    private static final List<Extension> extensions = List.of(AutolinkExtension.create(), FootnotesExtension.create(), InsExtension.create(), NotificationsExtension.create().withClassMapper(n -> "notification notification-" + n.name().toLowerCase()), TaskListItemsExtension.create(), StrikethroughExtension.create(), TablesExtension.create());
    private Browser browser;
    private String text = "";
    private int htmlDocumentHeight = 0;
    private Runnable renderCompletionHandler = null;
    private String htmlHeader;
    private boolean ignoreLocation = true;

    public MarkdownViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.browser = WidgetHelper.createBrowser((Composite)this, (int)0, null);
        this.browser.addProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
        this.browser.addLocationListener((LocationListener)new /* Unavailable Anonymous Inner Class!! */);
        FontData f = JFaceResources.getDefaultFont().getFontData()[0];
        this.htmlHeader = "<html><head><style>body { font-family: " + f.getName() + "; font-size: " + f.getHeight() + "px; font-weight: normal; margin: 0; padding: 0; }.notification { padding: 4px 5px 5px; margin-top: 0.5rem; margin-bottom: 1rem; border: 1px solid transparent; border-radius: 0.5rem; box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.7); font-size: 120%; } .notification-info { color: #07525e; background-color: #d1ecf1; border-color: #bee5eb; } .notification-success { color: #125522; background-color: #d4edda; border-color: #c3e6cb; } .notification-warning { color: #6a4d00; background-color: #fff3cd; border-color: #ffeeba; } .notification-error { color: #900000; background: #ffd2d2; border-color: #f1a899; }</style></head><body><div class=\"content\" style=\"padding-left: 5px; padding-right: 5px;\">";
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint != -1) {
            return super.computeSize(wHint, hHint, changed);
        }
        return new Point(wHint == -1 ? 100 : wHint, this.htmlDocumentHeight);
    }

    public void setText(String text) {
        this.htmlDocumentHeight = 0;
        this.text = text != null ? text : "";
        Parser parser = Parser.builder().extensions((Iterable)extensions).build();
        Node document = parser.parse(this.text);
        HtmlRenderer renderer = HtmlRenderer.builder().extensions((Iterable)extensions).build();
        String html = this.htmlHeader + renderer.render(document) + "</div></body></html>";
        this.ignoreLocation = true;
        this.browser.setText(html);
    }

    public String getText() {
        return this.text;
    }

    public Runnable getRenderCompletionHandler() {
        return this.renderCompletionHandler;
    }

    public void setRenderCompletionHandler(Runnable renderCompletionHandler) {
        this.renderCompletionHandler = renderCompletionHandler;
    }
}

