/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.netxms.client.maps.NetworkMapLink;

public class MultiConnectionAnchor
extends ChopboxAnchor {
    private static final int MAX_LINK_COUNT = 5;
    private static final int[] MULTIPLIERS;
    private NetworkMapLink link;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = -1;
        nArray[3] = 2;
        nArray[4] = -2;
        nArray[5] = 3;
        nArray[6] = -3;
        nArray[7] = 4;
        nArray[8] = -4;
        nArray[9] = 5;
        nArray[10] = -5;
        nArray[11] = 6;
        nArray[12] = -6;
        MULTIPLIERS = nArray;
    }

    public MultiConnectionAnchor(IFigure owner, NetworkMapLink link) {
        super(owner);
        this.link = link;
    }

    public Point getLocation(Point reference) {
        double yOffset;
        double xOffset;
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        this.getOwner().translateToAbsolute((Translatable)r);
        double centerX = r.getCenter().preciseX();
        double centerY = r.getCenter().preciseY();
        if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        double dx = reference.preciseX() - centerX;
        double dy = reference.preciseY() - centerY;
        double scale = 0.5 / Math.max(Math.abs(dx) / (double)r.width, Math.abs(dy) / (double)r.height);
        dx *= scale;
        dy *= scale;
        double adj = Math.abs(reference.preciseX() - centerX);
        double opp = Math.abs(reference.preciseY() - centerY);
        double theta = Math.atan(opp / adj);
        if (centerX < reference.preciseX() && centerY < reference.preciseY() || centerX > reference.preciseX() && centerY > reference.preciseY()) {
            xOffset = centerX + (double)(0.5f * (float)Math.min(r.height, r.width) / 5.0f * (float)MULTIPLIERS[this.link.getPosition() % MULTIPLIERS.length]) * Math.sin(-theta);
            yOffset = centerY + (double)(0.5f * (float)Math.min(r.height, r.width) / 5.0f * (float)MULTIPLIERS[this.link.getPosition() % MULTIPLIERS.length]) * Math.cos(-theta);
        } else {
            xOffset = centerX + (double)(0.5f * (float)Math.min(r.height, r.width) / 5.0f * (float)MULTIPLIERS[this.link.getPosition() % MULTIPLIERS.length]) * Math.sin(theta);
            yOffset = centerY + (double)(0.5f * (float)Math.min(r.height, r.width) / 5.0f * (float)MULTIPLIERS[this.link.getPosition() % MULTIPLIERS.length]) * Math.cos(theta);
        }
        centerX = dx + xOffset;
        centerY = dy + yOffset;
        return new Point((double)Math.round(centerX), (double)Math.round(centerY));
    }
}

