/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.preferencepages;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.dialogs.ThemeEditDialog;
import org.netxms.ui.eclipse.console.resources.DefaultDarkTheme;
import org.netxms.ui.eclipse.console.resources.DefaultLightTheme;
import org.netxms.ui.eclipse.console.resources.Theme;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ThemePrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo themeSelector;
    private Button importButton;
    private Button exportButton;
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private List<Theme> themes = new ArrayList<Theme>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 6;
        dialogArea.setLayout((Layout)layout);
        this.loadThemes();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 4;
        this.themeSelector = WidgetHelper.createLabeledCombo(dialogArea, 2060, "Active theme", gd);
        this.updateThemeDropDown();
        String currentTheme = this.getPreferenceStore().getString("CurrentTheme");
        if (currentTheme != null && !currentTheme.isEmpty()) {
            int index = this.themeSelector.indexOf(currentTheme);
            this.themeSelector.select(index != -1 ? index : 0);
        } else {
            this.themeSelector.select(0);
        }
        this.themeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePrefs.this.onThemeSelectionChange();
            }
        });
        this.editButton = new Button(dialogArea, 8);
        this.editButton.setText("&Edit...");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 90;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.setEnabled(this.themeSelector.getSelectionIndex() > 2);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePrefs.this.editTheme();
            }
        });
        this.removeButton = new Button(dialogArea, 8);
        this.removeButton.setText("&Remove");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 90;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setEnabled(this.themeSelector.getSelectionIndex() > 2);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePrefs.this.removeTheme();
            }
        });
        this.importButton = new Button(dialogArea, 8);
        this.importButton.setText("&Import...");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 90;
        this.importButton.setLayoutData((Object)gd);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePrefs.this.importTheme();
            }
        });
        this.newButton = new Button(dialogArea, 8);
        this.newButton.setText("&New...");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 90;
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePrefs.this.addNewTheme();
            }
        });
        this.exportButton = new Button(dialogArea, 8);
        this.exportButton.setText("E&xport...");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 90;
        this.exportButton.setLayoutData((Object)gd);
        this.exportButton.setEnabled(this.themeSelector.getSelectionIndex() > 2);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemePrefs.this.exportTheme();
            }
        });
        return dialogArea;
    }

    private void onThemeSelectionChange() {
        int index = this.themeSelector.getSelectionIndex();
        this.editButton.setEnabled(index > 2);
        this.removeButton.setEnabled(index > 2);
        this.exportButton.setEnabled(index > 2);
    }

    private void selectTheme(Theme theme) {
        int index = this.themeSelector.indexOf(theme.getName());
        this.themeSelector.select(index != -1 ? index : 0);
        this.onThemeSelectionChange();
    }

    private void updateThemeDropDown() {
        this.themes.sort(new Comparator<Theme>(){

            @Override
            public int compare(Theme t1, Theme t2) {
                return t1.getName().compareToIgnoreCase(t2.getName());
            }
        });
        this.themeSelector.removeAll();
        this.themeSelector.add("[automatic]");
        this.themeSelector.add("Light [built-in]");
        this.themeSelector.add("Dark [built-in]");
        for (Theme t : this.themes) {
            this.themeSelector.add(t.getName());
        }
    }

    private void loadThemes() {
        File base = ThemeEngine.getThemeStorageDirectory();
        if (base.isDirectory()) {
            File[] fileArray = base.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    Theme t = Theme.load(f);
                    t.setMissingElements(ThemePrefs.getAutomaticTheme());
                    this.themes.add(t);
                }
                catch (Exception e) {
                    Activator.logError("Error loading theme file " + f.getAbsolutePath(), e);
                }
                ++n2;
            }
        }
    }

    private void addNewTheme() {
        Theme currentTheme;
        int index = this.themeSelector.getSelectionIndex();
        switch (index) {
            case 0: {
                currentTheme = ThemePrefs.getAutomaticTheme();
                break;
            }
            case 1: {
                currentTheme = new DefaultLightTheme();
                break;
            }
            case 2: {
                currentTheme = new DefaultDarkTheme();
                break;
            }
            default: {
                currentTheme = this.themes.get(index - 3);
            }
        }
        Theme theme = new Theme("New Theme", currentTheme);
        ThemeEditDialog dlg = new ThemeEditDialog(this.getShell(), theme);
        if (dlg.open() == 0) {
            try {
                ThemeEngine.saveTheme(theme);
                this.themes.add(theme);
                this.updateThemeDropDown();
                this.selectTheme(theme);
            }
            catch (Exception e) {
                MessageDialogHelper.openError(this.getShell(), "Error", String.format("Cannot save theme (%s)", e.getLocalizedMessage()));
                Activator.getDefault();
                Activator.logError("Cannot save theme", e);
            }
        }
    }

    private void importTheme() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dlg.setFilterNames(new String[]{"XML files", "All files"});
        String importFileName = dlg.open();
        if (importFileName == null) {
            return;
        }
        try {
            Theme theme = Theme.load(new File(importFileName));
            ThemeEngine.saveTheme(theme);
            this.themes.add(theme);
            this.updateThemeDropDown();
            this.selectTheme(theme);
        }
        catch (Exception e) {
            MessageDialogHelper.openError(this.getShell(), "Error", String.format("Cannot import theme (%s)", e.getLocalizedMessage()));
            Activator.getDefault();
            Activator.logError("Cannot import theme", e);
        }
    }

    private void editTheme() {
        int index = this.themeSelector.getSelectionIndex();
        if (index < 3) {
            return;
        }
        Theme theme = this.themes.get(index - 3);
        String oldName = theme.getName();
        ThemeEditDialog dlg = new ThemeEditDialog(this.getShell(), theme);
        if (dlg.open() == 0) {
            try {
                if (!oldName.equals(theme.getName())) {
                    ThemeEngine.deleteTheme(oldName);
                }
                ThemeEngine.saveTheme(theme);
                this.updateThemeDropDown();
                this.selectTheme(theme);
            }
            catch (Exception e) {
                MessageDialogHelper.openError(this.getShell(), "Error", String.format("Cannot save theme (%s)", e.getLocalizedMessage()));
                Activator.getDefault();
                Activator.logError("Cannot save theme", e);
            }
        }
    }

    private void removeTheme() {
        int index = this.themeSelector.getSelectionIndex();
        if (index < 3) {
            return;
        }
        Theme theme = this.themes.get(index - 3);
        if (!MessageDialogHelper.openQuestion(this.getShell(), "Remove Theme", String.format("Theme %s will be removed. Are you sure?", theme.getName()))) {
            return;
        }
        ThemeEngine.deleteTheme(theme.getName());
        this.updateThemeDropDown();
        this.themeSelector.select(0);
        this.onThemeSelectionChange();
    }

    private void exportTheme() {
        int index = this.themeSelector.getSelectionIndex();
        if (index < 3) {
            return;
        }
        Theme theme = this.themes.get(index - 3);
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFileName(String.valueOf(theme.getName()) + ".xml");
        String exportFileName = dlg.open();
        if (exportFileName == null) {
            return;
        }
        try {
            theme.save(new File(exportFileName));
        }
        catch (Exception e) {
            MessageDialogHelper.openError(this.getShell(), "Error", String.format("Cannot export theme (%s)", e.getLocalizedMessage()));
            Activator.getDefault();
            Activator.logError("Cannot export theme", e);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.themeSelector.select(0);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.exportButton.setEnabled(false);
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("CurrentTheme", this.themeSelector.getText());
        ThemeEngine.reload();
        return super.performOk();
    }

    private static Theme getAutomaticTheme() {
        return WidgetHelper.isSystemDarkTheme() ? new DefaultDarkTheme() : new DefaultLightTheme();
    }
}

