/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objecttools.dialogs.CreateNewToolDialog;
import org.netxms.nxmc.modules.objecttools.propertypages.AccessControl;
import org.netxms.nxmc.modules.objecttools.propertypages.Columns;
import org.netxms.nxmc.modules.objecttools.propertypages.Filter;
import org.netxms.nxmc.modules.objecttools.propertypages.General;
import org.netxms.nxmc.modules.objecttools.propertypages.InputFields;
import org.netxms.nxmc.modules.objecttools.views.ObjectToolsEditor;
import org.netxms.nxmc.modules.objecttools.views.helpers.ObjectToolsComparator;
import org.netxms.nxmc.modules.objecttools.views.helpers.ObjectToolsFilter;
import org.netxms.nxmc.modules.objecttools.views.helpers.ObjectToolsLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectToolsEditor
extends ConfigurationView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectToolsEditor.class);
    private static final String TABLE_CONFIG_PREFIX = "ObjectToolsEditor";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private Map<Long, ObjectTool> tools = new HashMap();
    private SortableTableViewer viewer;
    private NXCSession session = Registry.getSession();
    private Action actionNew;
    private Action actionEdit;
    private Action actionClone;
    private Action actionDelete;
    private Action actionDisable;
    private Action actionEnable;

    public ObjectToolsEditor() {
        super(LocalizationHelper.getI18n(ObjectToolsEditor.class).tr("Object Tools"), ResourceManager.getImageDescriptor((String)"icons/config-views/tools.png"), "ObjectTools", true);
    }

    public void createContent(Composite parent) {
        String[] columnNames = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Description")};
        int[] columnWidths = new int[]{90, 200, 100, 200};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 1, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"ObjectToolsEditor");
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectToolsLabelProvider());
        ObjectToolsFilter filter = new ObjectToolsFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.setComparator((ViewerComparator)new ObjectToolsComparator());
        this.viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null) {
                this.actionEdit.setEnabled(selection.size() == 1);
                this.actionClone.setEnabled(selection.size() == 1);
                this.actionDelete.setEnabled(selection.size() > 0);
                this.actionDisable.setEnabled(ObjectToolsEditor.containsEnabled((IStructuredSelection)selection));
                this.actionEnable.setEnabled(ObjectToolsEditor.containsDisabled((IStructuredSelection)selection));
            }
        });
        this.viewer.addDoubleClickListener(e -> this.editTool());
        this.viewer.getTable().addDisposeListener((DisposeListener & Serializable)e -> WidgetHelper.saveTableViewerSettings((SortableTableViewer)this.viewer, (String)"ObjectToolsEditor"));
        this.createActions();
        this.createContextMenu();
        this.session.addListener((SessionListener)this);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private static boolean containsDisabled(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (((ObjectTool)o).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static boolean containsEnabled(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (!((ObjectTool)o).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionDisable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+I", (IAction)this.actionDisable);
        this.actionEnable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+E", (IAction)this.actionEnable);
        this.actionClone = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+C", (IAction)this.actionClone);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionClone);
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (ObjectToolsEditor.containsEnabled((IStructuredSelection)selection)) {
            mgr.add((IAction)this.actionDisable);
        }
        if (ObjectToolsEditor.containsDisabled((IStructuredSelection)selection)) {
            mgr.add((IAction)this.actionEnable);
        }
        mgr.add((IAction)this.actionDelete);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editTool() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Long toolId = ((ObjectTool)selection.getFirstElement()).getId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createTool() {
        CreateNewToolDialog dlg = new CreateNewToolDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteTools() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirmation"), (String)this.i18n.tr("Do you really want to delete selected object tools?"))) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void saveObjectTool(ObjectToolDetails details) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void enableTools(boolean enable) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<Long> toolIdList = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            if (((ObjectTool)o).isEnabled() == enable) continue;
            toolIdList.add(((ObjectTool)o).getId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void cloneTool() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectTool currentTool = (ObjectTool)selection.getFirstElement();
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), "Clone Object Tool", "Enter name for cloned object tool", this.i18n.tr("Copy of {}", (Object)currentTool.getName()), (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1009: {
                this.getDisplay().asyncExec(() -> this.refresh());
                break;
            }
            case 1015: {
                this.getDisplay().asyncExec(() -> {
                    this.tools.remove(n.getSubCode());
                    this.viewer.setInput((Object)this.tools.values().toArray());
                });
            }
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private boolean showObjectToolPropertyPages(ObjectToolDetails objectTool) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(objectTool)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("access_control", (IPreferencePage)new AccessControl(objectTool)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("filter", (IPreferencePage)new Filter(objectTool)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("input_fields", (IPreferencePage)new InputFields(objectTool)));
        if (objectTool.getToolType() == 3 || objectTool.getToolType() == 2) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("columns", (IPreferencePage)new Columns(objectTool)));
        }
        15 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

