/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.AssetGroup;
import org.netxms.client.objects.AssetRoot;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Circuit;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.SubtreeType;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.views.ObjectBrowser;
import org.netxms.nxmc.modules.objects.widgets.ObjectTree;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectBrowser
extends NavigationView {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectBrowser.class);
    private SubtreeType subtreeType;
    private ObjectFilter objectFilter;
    private ObjectTree objectTree;
    private Action actionMoveObject;
    private Action actionMoveTemplate;
    private Action actionMoveBusinessService;
    private Action actionMoveDashboard;
    private Action actionMoveMap;
    private Action actionMoveAsset;

    public ObjectBrowser(String name, ImageDescriptor image, SubtreeType subtreeType, ObjectFilter objectFilter) {
        super(name, image, "objects.browser." + subtreeType.toString().toLowerCase(), true, true, true);
        this.subtreeType = subtreeType;
        this.objectFilter = objectFilter;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.objectTree != null ? this.objectTree.getSelectionProvider() : null;
    }

    public void setSelection(Object selection) {
        this.objectTree.getTreeViewer().setSelection((ISelection)new StructuredSelection(selection));
        this.objectTree.getTreeViewer().reveal(selection);
    }

    protected void createContent(Composite parent) {
        this.objectTree = new ObjectTree(parent, 0, true, ObjectBrowser.calculateClassFilter((SubtreeType)this.subtreeType), this.objectFilter, (View)this, true, false);
        this.createActions();
        1 menuManager = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuManager.createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.objectTree.enableDropSupport(this);
        this.objectTree.enableDragSupport();
        TreeViewer treeViewer = this.objectTree.getTreeViewer();
        TreeViewerEditor.create((TreeViewer)treeViewer, (ColumnViewerEditorActivationStrategy)new /* Unavailable Anonymous Inner Class!! */, (int)1);
        TextCellEditor editor = new TextCellEditor((Composite)treeViewer.getTree(), 2048);
        editor.addListener((ICellEditorListener)new /* Unavailable Anonymous Inner Class!! */);
        treeViewer.setCellEditors(new CellEditor[]{editor});
        treeViewer.setColumnProperties(new String[]{"name"});
        treeViewer.setCellModifier((ICellModifier)new /* Unavailable Anonymous Inner Class!! */);
        this.objectTree.getTreeViewer().expandToLevel(2);
    }

    private void createActions() {
        this.actionMoveObject = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveObject.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveObject");
        this.actionMoveTemplate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveTemplate.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveTemplate");
        this.actionMoveBusinessService = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveBusinessService.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveBusinessService");
        this.actionMoveDashboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveDashboard.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveDashboard");
        this.actionMoveMap = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveAsset = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveAsset.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveAsset");
    }

    private void moveObject(SubtreeType subtree) {
        if (!this.isValidSelectionForMove(subtree)) {
            return;
        }
        ArrayList<AbstractObject> selectedObjects = new ArrayList<AbstractObject>();
        ArrayList<AbstractObject> parentObjects = new ArrayList<AbstractObject>();
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        for (int i = 0; i < selection.length; ++i) {
            selectedObjects.add((AbstractObject)selection[i].getData());
            parentObjects.add((AbstractObject)selection[i].getParentItem().getData());
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), switch (12.$SwitchMap$org$netxms$nxmc$modules$objects$SubtreeType[subtree.ordinal()]) {
            case 1 -> ObjectSelectionDialog.createContainerSelectionFilter();
            case 2 -> ObjectSelectionDialog.createTemplateGroupSelectionFilter();
            case 3 -> ObjectSelectionDialog.createBusinessServiceSelectionFilter();
            case 4 -> ObjectSelectionDialog.createDashboardGroupSelectionFilter();
            case 5 -> ObjectSelectionDialog.createNetworkMapGroupsSelectionFilter();
            case 6 -> ObjectSelectionDialog.createAssetGroupsSelectionFilter();
            default -> null;
        }, selectedObjects);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject target = (AbstractObject)dlg.getSelectedObjects().get(0);
            for (int i = 0; i < selection.length; ++i) {
                this.moveObject(target, (AbstractObject)parentObjects.get(i), (AbstractObject)selectedObjects.get(i), true);
            }
        }
    }

    public static Set<Integer> calculateClassFilter(SubtreeType subtreeType) {
        HashSet<Integer> classFilter = new HashSet<Integer>();
        switch (12.$SwitchMap$org$netxms$nxmc$modules$objects$SubtreeType[subtreeType.ordinal()]) {
            case 6: {
                classFilter.add(16);
                classFilter.add(17);
                classFilter.add(18);
                break;
            }
            case 3: {
                classFilter.add(28);
                classFilter.add(15);
                classFilter.add(27);
                break;
            }
            case 4: {
                classFilter.add(23);
                classFilter.add(36);
                classFilter.add(22);
                break;
            }
            case 1: {
                classFilter.add(33);
                classFilter.add(35);
                classFilter.add(30);
                classFilter.add(14);
                classFilter.add(29);
                classFilter.add(13);
                classFilter.add(5);
                classFilter.add(3);
                classFilter.add(31);
                classFilter.add(11);
                classFilter.add(2);
                classFilter.add(32);
                classFilter.add(37);
                classFilter.add(7);
                classFilter.add(1);
                classFilter.add(12);
                classFilter.add(34);
                break;
            }
            case 5: {
                classFilter.add(21);
                classFilter.add(20);
                classFilter.add(19);
                break;
            }
            case 7: {
                classFilter.add(14);
                classFilter.add(3);
                classFilter.add(4);
                classFilter.add(11);
                classFilter.add(2);
                classFilter.add(1);
                classFilter.add(12);
                classFilter.add(6);
                break;
            }
            case 2: {
                classFilter.add(8);
                classFilter.add(9);
                classFilter.add(10);
                if (!Registry.getSession().getClientConfigurationHintAsBoolean("ObjectBrowser.ShowTargetsUnderTemplates", false)) break;
                classFilter.add(33);
                classFilter.add(14);
                classFilter.add(29);
                classFilter.add(3);
                classFilter.add(31);
                classFilter.add(11);
                classFilter.add(2);
                classFilter.add(37);
                classFilter.add(12);
            }
        }
        return classFilter;
    }

    public boolean isValidSelectionForMove(SubtreeType subtree) {
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        if (selection.length < 1) {
            return false;
        }
        for (int i = 0; i < selection.length; ++i) {
            if (this.isValidObjectForMove(selection, i, subtree) && ((AbstractObject)selection[0].getParentItem().getData()).getObjectId() == ((AbstractObject)selection[i].getParentItem().getData()).getObjectId()) continue;
            return false;
        }
        return true;
    }

    public boolean isValidObjectForMove(TreeItem[] selection, int i, SubtreeType subtree) {
        if (selection[i].getParentItem() == null) {
            return false;
        }
        AbstractObject currentObject = (AbstractObject)selection[i].getData();
        AbstractObject parentObject = (AbstractObject)selection[i].getParentItem().getData();
        switch (12.$SwitchMap$org$netxms$nxmc$modules$objects$SubtreeType[subtree.ordinal()]) {
            case 6: {
                return !(!(currentObject instanceof Asset) && !(currentObject instanceof AssetGroup) || !(parentObject instanceof AssetGroup) && !(parentObject instanceof AssetRoot));
            }
            case 1: {
                return !(!(currentObject instanceof Node) && !(currentObject instanceof Cluster) && !(currentObject instanceof Subnet) && !(currentObject instanceof Condition) && !(currentObject instanceof Rack) && !(currentObject instanceof MobileDevice) && !(currentObject instanceof Circuit) && !(currentObject instanceof Collector) && !(currentObject instanceof Container) && !(currentObject instanceof Sensor) || !(parentObject instanceof Collector) && !(parentObject instanceof Container) && !(parentObject instanceof ServiceRoot));
            }
            case 2: {
                return !(!(currentObject instanceof Template) && !(currentObject instanceof TemplateGroup) || !(parentObject instanceof TemplateGroup) && !(parentObject instanceof TemplateRoot));
            }
            case 3: {
                return currentObject instanceof BusinessService && (parentObject instanceof BusinessService || parentObject instanceof BusinessServiceRoot);
            }
            case 5: {
                return !(!(currentObject instanceof NetworkMap) && !(currentObject instanceof NetworkMapGroup) || !(parentObject instanceof NetworkMapGroup) && !(parentObject instanceof NetworkMapRoot));
            }
            case 4: {
                return !(!(currentObject instanceof Dashboard) && !(currentObject instanceof DashboardGroup) || !(parentObject instanceof DashboardRoot) && !(parentObject instanceof DashboardGroup) && !(parentObject instanceof Dashboard));
            }
        }
        return false;
    }

    public void moveObject(AbstractObject destination, AbstractObject source, AbstractObject movableObject, boolean move) {
        if (destination.getObjectId() == source.getObjectId()) {
            return;
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean selectObject(AbstractObject object) {
        this.objectTree.selectObject(object);
        if (this.objectTree.getFirstSelectedObject() != object.getObjectId()) {
            this.objectTree.setFilterText("");
            this.objectTree.selectObject(object);
        }
        return this.objectTree.getFirstSelectedObject() == object.getObjectId();
    }

    public void refresh() {
        this.objectTree.refresh();
    }
}

