/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.MarkdownViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class CommentsView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(CommentsView.class);
    private MarkdownViewer markdownViewer;
    private Text textViewer;
    private Control currentViewer = null;
    private Composite content;
    private boolean markdownMode = false;
    private boolean showEmptyComments = !Registry.getSession().getClientConfigurationHintAsBoolean("ObjectOverview.ShowCommentsOnlyIfPresent", true);

    public CommentsView() {
        super(LocalizationHelper.getI18n(CommentsView.class).tr("Comments"), ResourceManager.getImageDescriptor((String)"icons/object-views/comments.png"), "objects.comments", false);
    }

    public boolean isValidForContext(Object context) {
        if (context == null || !(context instanceof AbstractObject)) {
            return false;
        }
        if (this.showEmptyComments) {
            return true;
        }
        String comments = ((AbstractObject)context).getComments();
        return !comments.isBlank() && (!comments.startsWith("{\u007f}") || !comments.substring("{\u007f}".length()).isBlank());
    }

    public int getPriority() {
        return 300;
    }

    protected void createContent(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FillLayout());
    }

    protected void onObjectChange(AbstractObject object) {
        this.onObjectUpdate(object);
    }

    protected void onObjectUpdate(AbstractObject object) {
        String comments;
        String string = comments = object != null ? object.getComments() : "";
        if (comments.startsWith("{\u007f}")) {
            this.createViewer(true);
            this.markdownViewer.setText(comments.substring("{\u007f}".length()));
        } else {
            this.createViewer(false);
            this.textViewer.setText(comments);
        }
    }

    public void refresh() {
        long objectId = this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createViewer(boolean markdownMode) {
        if (this.currentViewer != null && !this.currentViewer.isDisposed()) {
            if (this.markdownMode == markdownMode) {
                return;
            }
            this.currentViewer.dispose();
        }
        if (markdownMode) {
            this.markdownViewer = new MarkdownViewer(this.content, 0);
            this.currentViewer = this.markdownViewer;
        } else {
            this.textViewer = new Text(this.content, 770);
            this.textViewer.setFont(JFaceResources.getDialogFont());
            this.currentViewer = this.textViewer;
        }
        this.markdownMode = markdownMode;
    }
}

