/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.xnap.commons.i18n.I18n;

public class AutoApply
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(AutoApply.class);
    private Template template;
    private Button checkboxEnableApply;
    private Button checkboxEnableRemove;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialApplyFilter;

    public AutoApply(AbstractObject object) {
        super(LocalizationHelper.getI18n(AutoApply.class).tr("Automatic Apply Rules"), object);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.template = (Template)this.object;
        if (this.object == null) {
            return dialogArea;
        }
        this.initialBind = this.template.isAutoApplyEnabled();
        this.initialUnbind = this.template.isAutoRemoveEnabled();
        this.initialApplyFilter = this.template.getAutoApplyFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableApply = new Button(dialogArea, 32);
        this.checkboxEnableApply.setText(this.i18n.tr("Apply this template automatically to objects selected by filter"));
        this.checkboxEnableApply.setSelection(this.template.isAutoApplyEnabled());
        this.checkboxEnableApply.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkboxEnableRemove = new Button(dialogArea, 32);
        this.checkboxEnableRemove.setText(this.i18n.tr("Remove this template automatically when object no longer passes through filter"));
        this.checkboxEnableRemove.setSelection(this.template.isAutoRemoveEnabled());
        this.checkboxEnableRemove.setEnabled(this.template.isAutoApplyEnabled());
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Filtering script"));
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\n\t$node\tnode being tested (null if object is not a node).\n\t$object\tobject being tested.\n\t$template\tthis template object.\n\nReturn value: true to apply this template to node, false to remove, null to make no changes.");
        this.filterSource.setText(this.template.getAutoApplyFilter());
        this.filterSource.setEnabled(this.template.isAutoApplyEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        boolean apply = this.checkboxEnableApply.getSelection();
        boolean remove = this.checkboxEnableRemove.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialApplyFilter.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        int flags = ((Template)this.object).getAutoApplyFlags();
        flags = apply ? flags | 1 : flags & 0xFFFFFFFE;
        flags = remove ? flags | 2 : flags & 0xFFFFFFFD;
        md.setAutoBindFlags(Integer.valueOf(flags));
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    public String getId() {
        return "autoApply";
    }

    public boolean isVisible() {
        return this.object instanceof Template;
    }
}

