/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectFilter;
import org.netxms.client.SessionListener;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.RoundedLabel;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.AgentConfigurationEditor;
import org.netxms.nxmc.modules.alarms.views.AlarmsView;
import org.netxms.nxmc.modules.assetmanagement.LinkAssetToObjectAction;
import org.netxms.nxmc.modules.assetmanagement.LinkObjectToAssetAction;
import org.netxms.nxmc.modules.assetmanagement.UnlinkAssetFromObjectAction;
import org.netxms.nxmc.modules.assetmanagement.UnlinkObjectFromAssetAction;
import org.netxms.nxmc.modules.assetmanagement.views.AssetSummaryView;
import org.netxms.nxmc.modules.assetmanagement.views.AssetView;
import org.netxms.nxmc.modules.businessservice.views.BusinessServiceAvailabilityView;
import org.netxms.nxmc.modules.businessservice.views.BusinessServiceChecksView;
import org.netxms.nxmc.modules.dashboards.ExportDashboardAction;
import org.netxms.nxmc.modules.dashboards.ImportDashboardAction;
import org.netxms.nxmc.modules.dashboards.views.ContextDashboardView;
import org.netxms.nxmc.modules.dashboards.views.DashboardView;
import org.netxms.nxmc.modules.datacollection.views.DataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.PerformanceView;
import org.netxms.nxmc.modules.datacollection.views.PolicyListView;
import org.netxms.nxmc.modules.datacollection.views.SummaryDataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.ThresholdSummaryView;
import org.netxms.nxmc.modules.filemanager.views.AgentFileManager;
import org.netxms.nxmc.modules.networkmaps.views.PredefinedMapView;
import org.netxms.nxmc.modules.nxsl.views.ScriptExecutorView;
import org.netxms.nxmc.modules.objects.ObjectCreateMenuManager;
import org.netxms.nxmc.modules.objects.ObjectLogMenuManager;
import org.netxms.nxmc.modules.objects.ObjectMenuFactory;
import org.netxms.nxmc.modules.objects.ObjectPropertiesManager;
import org.netxms.nxmc.modules.objects.SubtreeType;
import org.netxms.nxmc.modules.objects.actions.ForcedPolicyDeploymentAction;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.modules.objects.dialogs.ObjectViewManagerDialog;
import org.netxms.nxmc.modules.objects.views.AccessPointsView;
import org.netxms.nxmc.modules.objects.views.AddressMapView;
import org.netxms.nxmc.modules.objects.views.ArpCacheView;
import org.netxms.nxmc.modules.objects.views.ChassisView;
import org.netxms.nxmc.modules.objects.views.CommentsView;
import org.netxms.nxmc.modules.objects.views.DeviceView;
import org.netxms.nxmc.modules.objects.views.Dot1xStatusView;
import org.netxms.nxmc.modules.objects.views.HardwareInventoryView;
import org.netxms.nxmc.modules.objects.views.InterfacesView;
import org.netxms.nxmc.modules.objects.views.MaintenanceJournalView;
import org.netxms.nxmc.modules.objects.views.NetworkServiceView;
import org.netxms.nxmc.modules.objects.views.NodesView;
import org.netxms.nxmc.modules.objects.views.OSPFView;
import org.netxms.nxmc.modules.objects.views.ObjectBrowser;
import org.netxms.nxmc.modules.objects.views.ObjectOverviewView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.PhysicalLinkView;
import org.netxms.nxmc.modules.objects.views.PortView;
import org.netxms.nxmc.modules.objects.views.ProcessesView;
import org.netxms.nxmc.modules.objects.views.RackView;
import org.netxms.nxmc.modules.objects.views.RadioInterfacesAP;
import org.netxms.nxmc.modules.objects.views.RadioInterfacesController;
import org.netxms.nxmc.modules.objects.views.RemoteControlView;
import org.netxms.nxmc.modules.objects.views.ResourcesView;
import org.netxms.nxmc.modules.objects.views.RoutingTableView;
import org.netxms.nxmc.modules.objects.views.ScreenshotView;
import org.netxms.nxmc.modules.objects.views.ServicesView;
import org.netxms.nxmc.modules.objects.views.SoftwareInventoryView;
import org.netxms.nxmc.modules.objects.views.StatusMapView;
import org.netxms.nxmc.modules.objects.views.SwitchForwardingDatabaseView;
import org.netxms.nxmc.modules.objects.views.TemplateTargets;
import org.netxms.nxmc.modules.objects.views.UserSessionsView;
import org.netxms.nxmc.modules.objects.views.VpnView;
import org.netxms.nxmc.modules.objects.views.WirelessStations;
import org.netxms.nxmc.modules.objects.views.elements.Comments;
import org.netxms.nxmc.modules.objects.views.elements.ObjectInfo;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.PollStates;
import org.netxms.nxmc.modules.snmp.views.MibExplorer;
import org.netxms.nxmc.modules.worldmap.views.ObjectGeoLocationView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.services.ObjectActionDescriptor;
import org.netxms.nxmc.services.ObjectViewDescriptor;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class ObjectsPerspective
extends Perspective
implements ISelectionProvider {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectsPerspective.class);
    private ObjectBrowser objectBrowser;
    private SubtreeType subtreeType;
    private ObjectFilter objectFilter;
    private StructuredSelection selection = new StructuredSelection();
    private Composite headerArea;
    private Label objectName;
    private RoundedLabel objectStatus;
    private Composite objectDetails;
    private ObjectInfo objectGeneralInfo;
    private PollStates objectPollState;
    private Comments objectComments;
    private ToolBar objectToolBar;
    private ToolBar objectMenuBar;
    private ToolBar perspectiveToolBar;
    private Label expandButton;
    private Image imageEditConfig;
    private Image imageExecuteScript;
    private Image imageOpenMibExplorer;
    private Image imageTakeScreenshot;
    private Image imageRemoteControl;
    private Image imageManageViews;
    private List<ObjectAction<?>> actionContributions = new ArrayList();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    protected ObjectsPerspective(String id, String name, Image image, SubtreeType subtreeType, ObjectFilter objectFilter) {
        super(id, name, image);
        this.subtreeType = subtreeType;
        this.objectFilter = objectFilter;
        this.imageEditConfig = ResourceManager.getImage((String)"icons/object-views/agent-config.png");
        this.imageExecuteScript = ResourceManager.getImage((String)"icons/object-views/script-executor.png");
        this.imageTakeScreenshot = ResourceManager.getImage((String)"icons/screenshot.png");
        this.imageRemoteControl = ResourceManager.getImage((String)"icons/object-views/remote-desktop.png");
        this.imageManageViews = ResourceManager.getImage((String)"icons/perspective-config.png");
        this.imageOpenMibExplorer = ResourceManager.getImage((String)"icons/object-views/mibexplorer.gif");
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = true;
        configuration.enableNavigationHistory = true;
        configuration.hasSupplementalArea = false;
        configuration.multiViewNavigationArea = false;
        configuration.multiViewMainArea = true;
        configuration.hasHeaderArea = true;
    }

    protected void configureViews() {
        this.objectBrowser = new ObjectBrowser(this.getName(), null, this.subtreeType, this.objectFilter);
        this.addNavigationView((NavigationView)this.objectBrowser);
        this.addMainView((View)new AccessPointsView());
        this.addMainView((View)new AddressMapView());
        this.addMainView((View)new AgentFileManager());
        this.addMainView((View)new AlarmsView());
        this.addMainView((View)new ArpCacheView());
        this.addMainView((View)new AssetSummaryView());
        this.addMainView((View)new AssetView());
        this.addMainView((View)new BusinessServiceAvailabilityView());
        this.addMainView((View)new BusinessServiceChecksView());
        this.addMainView((View)new ChassisView());
        this.addMainView((View)new CommentsView());
        this.addMainView((View)new DashboardView());
        this.addMainView((View)new DataCollectionView());
        this.addMainView((View)new DeviceView());
        this.addMainView((View)new Dot1xStatusView());
        this.addMainView((View)new HardwareInventoryView());
        this.addMainView((View)new InterfacesView());
        this.addMainView((View)new MaintenanceJournalView());
        this.addMainView((View)new NetworkServiceView());
        this.addMainView((View)new NodesView());
        this.addMainView((View)new ObjectGeoLocationView());
        this.addMainView((View)new ObjectOverviewView());
        this.addMainView((View)new OSPFView());
        this.addMainView((View)new PerformanceView());
        this.addMainView((View)new PhysicalLinkView());
        this.addMainView((View)new PolicyListView());
        this.addMainView((View)new PortView());
        this.addMainView((View)new PredefinedMapView());
        this.addMainView((View)new ProcessesView());
        this.addMainView((View)new RackView());
        this.addMainView((View)new RadioInterfacesAP());
        this.addMainView((View)new RadioInterfacesController());
        this.addMainView((View)new ResourcesView());
        this.addMainView((View)new RoutingTableView());
        this.addMainView((View)new ServicesView());
        this.addMainView((View)new SoftwareInventoryView());
        this.addMainView((View)new StatusMapView());
        this.addMainView((View)new SummaryDataCollectionView());
        this.addMainView((View)new SwitchForwardingDatabaseView());
        this.addMainView((View)new TemplateTargets());
        this.addMainView((View)new ThresholdSummaryView());
        this.addMainView((View)new UserSessionsView());
        this.addMainView((View)new VpnView());
        this.addMainView((View)new WirelessStations());
        NXCSession session = Registry.getSession();
        ServiceLoader<ObjectViewDescriptor> viewLoader = ServiceLoader.load(ObjectViewDescriptor.class, this.getClass().getClassLoader());
        for (ObjectViewDescriptor v : viewLoader) {
            String componentId = v.getRequiredComponentId();
            if (componentId != null && !session.isServerComponentRegistered(componentId)) continue;
            this.addMainView((View)v.createView());
        }
        this.actionContributions.add(new ForcedPolicyDeploymentAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        this.actionContributions.add(new LinkAssetToObjectAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        this.actionContributions.add(new UnlinkAssetFromObjectAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        this.actionContributions.add(new LinkObjectToAssetAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        this.actionContributions.add(new UnlinkObjectFromAssetAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        this.actionContributions.add(new ExportDashboardAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        this.actionContributions.add(new ImportDashboardAction(new ViewPlacement((Perspective)this), (ISelectionProvider)this));
        ViewPlacement viewPlacement = new ViewPlacement((Perspective)this);
        ServiceLoader<ObjectActionDescriptor> actionLoader = ServiceLoader.load(ObjectActionDescriptor.class, this.getClass().getClassLoader());
        for (ObjectActionDescriptor a : actionLoader) {
            String componentId = a.getRequiredComponentId();
            if (componentId != null && !session.isServerComponentRegistered(componentId)) continue;
            this.actionContributions.add(a.createAction(viewPlacement, (ISelectionProvider)this));
        }
        session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createHeaderArea(Composite parent) {
        this.headerArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 9;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginTop = 3;
        this.headerArea.setLayout((Layout)layout);
        this.objectName = new Label(this.headerArea, 16384);
        this.objectName.setFont(JFaceResources.getBannerFont());
        Menu objectNameMenu = new Menu((Control)this.objectName);
        MenuItem menuItem = new MenuItem(objectNameMenu, 8);
        menuItem.setText("&Copy");
        menuItem.setImage(SharedIcons.IMG_COPY);
        menuItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.objectName.setMenu(objectNameMenu);
        Label separator = new Label(this.headerArea, 514);
        GridData gd = new GridData(0x1000000, 4, false, true);
        gd.heightHint = 28;
        separator.setLayoutData((Object)gd);
        this.objectStatus = new RoundedLabel(this.headerArea);
        this.objectStatus.setToolTipText(this.i18n.tr("Object status"));
        gd = new GridData(4, 4, false, true);
        gd.widthHint = WidgetHelper.getTextWidth((Control)this.objectStatus, (String)(StatusDisplayInfo.getStatusText((ObjectStatus)ObjectStatus.UNMANAGED) + "10"));
        this.objectStatus.setLayoutData((Object)gd);
        separator = new Label(this.headerArea, 514);
        gd = new GridData(0x1000000, 4, false, true);
        gd.heightHint = 28;
        separator.setLayoutData((Object)gd);
        this.objectToolBar = new ToolBar(this.headerArea, 8519936);
        separator = new Label(this.headerArea, 514);
        gd = new GridData(0x1000000, 4, false, true);
        gd.heightHint = 28;
        separator.setLayoutData((Object)gd);
        this.objectMenuBar = new ToolBar(this.headerArea, 8519936);
        this.perspectiveToolBar = new ToolBar(this.headerArea, 8519936);
        gd = new GridData(131072, 0x1000000, true, false);
        this.perspectiveToolBar.setLayoutData((Object)gd);
        ToolItem item = new ToolItem(this.perspectiveToolBar, 4);
        item.setImage(this.imageManageViews);
        item.setToolTipText("Manage views");
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.expandButton = new Label(this.headerArea, 0);
        this.expandButton.setBackground(this.headerArea.getBackground());
        this.expandButton.setImage(SharedIcons.IMG_EXPAND);
        this.expandButton.setToolTipText(this.i18n.tr("Show additional object information"));
        this.expandButton.setCursor(parent.getDisplay().getSystemCursor(21));
        this.expandButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData(131072, 0x1000000, false, false);
        this.expandButton.setLayoutData((Object)gd);
        PreferenceStore.getInstance().addPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (PreferenceStore.getInstance().getAsBoolean("ObjectPerspective.showObjectDetails", false)) {
            this.showObjectDetails(true);
        }
    }

    private Menu createClosedViewMenu() {
        Menu menu = new Menu((Control)this.perspectiveToolBar);
        menu.addMenuListener((MenuListener)new /* Unavailable Anonymous Inner Class!! */);
        return menu;
    }

    private void createViewMenuItem(Menu menu) {
        ArrayList<View> objectViews = new ArrayList<View>();
        for (View v : this.getAllMainViews()) {
            if (v.isCloseable() || !(v instanceof ObjectView) || !((ObjectView)v).isHidden() || !((ViewWithContext)v).isValidForContext(this.selection.getFirstElement())) continue;
            objectViews.add(v);
        }
        objectViews.sort((v1, v2) -> v1.getName().compareToIgnoreCase(v2.getName()));
        for (View v : objectViews) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(v.getName());
            item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void showObjectDetails(boolean show) {
        if (show && this.objectDetails == null) {
            this.objectDetails = new Composite(this.headerArea, 0);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = ((GridLayout)this.headerArea.getLayout()).numColumns;
            this.objectDetails.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.objectDetails.setLayout((Layout)layout);
            this.objectGeneralInfo = new ObjectInfo(this.objectDetails, null, null);
            this.objectGeneralInfo.setVerticalAlignment(4);
            this.objectPollState = new PollStates(this.objectDetails, (OverviewPageElement)this.objectGeneralInfo, null);
            this.objectPollState.setVerticalAlignment(4);
            this.objectComments = new Comments(this.objectDetails, (OverviewPageElement)this.objectPollState, null);
            this.objectComments.setVerticalAlignment(4);
            AbstractObject object = (AbstractObject)this.selection.getFirstElement();
            if (object != null) {
                this.objectGeneralInfo.setObject(object);
                if (this.objectPollState.isApplicableForObject(object)) {
                    this.objectPollState.setObject(object);
                }
                this.objectComments.setObject(object);
            }
        } else if (!show && this.objectDetails != null) {
            this.objectDetails.dispose();
            this.objectDetails = null;
        }
        this.expandButton.setImage(show ? SharedIcons.IMG_COLLAPSE : SharedIcons.IMG_EXPAND);
        this.expandButton.setToolTipText(show ? this.i18n.tr("Hide additional object information") : this.i18n.tr("Show additional object information"));
        this.layoutMainArea();
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        super.navigationSelectionChanged(selection);
        if (selection.getFirstElement() instanceof AbstractObject) {
            AbstractObject object = (AbstractObject)selection.getFirstElement();
            this.selection = new StructuredSelection((Object)object);
            this.objectName.setText(object.getNameWithAlias());
            if (object.isInMaintenanceMode()) {
                this.objectStatus.setText(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()) + this.i18n.tr(" (maintenance)"));
            } else {
                this.objectStatus.setText(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
            }
            this.objectStatus.setLabelBackground(StatusDisplayInfo.getStatusBackgroundColor((ObjectStatus)object.getStatus()));
            if (this.objectDetails != null) {
                this.updateObjectDetails(object);
            }
            this.updateObjectToolBar(object);
            this.updateObjectMenuBar(object);
            this.updateContextDashboards(object);
        } else {
            this.selection = new StructuredSelection();
            this.objectName.setText("");
            this.objectStatus.setText("");
            this.objectStatus.setLabelBackground(null);
        }
        this.headerArea.layout();
        if (!this.selectionListeners.isEmpty()) {
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection);
            for (ISelectionChangedListener l : this.selectionListeners) {
                l.selectionChanged(e);
            }
        }
    }

    protected void updateContext(Object context) {
        super.updateContext(context);
        AbstractObject object = (AbstractObject)context;
        this.objectName.setText(object.getNameWithAlias());
        if (object.isInMaintenanceMode()) {
            this.objectStatus.setText(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()) + this.i18n.tr(" (maintenance)"));
        } else {
            this.objectStatus.setText(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        }
        this.objectStatus.setLabelBackground(StatusDisplayInfo.getStatusBackgroundColor((ObjectStatus)object.getStatus()));
        if (this.objectDetails != null) {
            this.updateObjectDetails(object);
        } else {
            this.headerArea.layout();
        }
    }

    private void updateObjectDetails(AbstractObject object) {
        this.objectGeneralInfo.setObject(object);
        if (this.objectPollState.isApplicableForObject(object)) {
            this.objectPollState.setObject(object);
            this.objectPollState.fixPlacement();
        } else {
            this.objectPollState.dispose();
            this.objectComments.fixPlacement();
        }
        this.objectComments.setObject(object);
        this.layoutMainArea();
    }

    private void updateObjectToolBar(AbstractObject object) {
        for (ToolItem item : this.objectToolBar.getItems()) {
            item.dispose();
        }
        this.addObjectToolBarItem(this.i18n.tr("Properties"), SharedIcons.IMG_PROPERTIES, () -> ObjectPropertiesManager.openObjectPropertiesDialog((AbstractObject)object, (Shell)this.getWindow().getShell(), (MessageAreaHolder)this.getMessageArea()));
        this.addObjectToolBarItem(this.i18n.tr("Execute script"), this.imageExecuteScript, () -> this.addMainView((View)new ScriptExecutorView(object.getObjectId(), object.getObjectId()), true, false));
        if (object instanceof Node && ((Node)object).hasAgent()) {
            this.addObjectToolBarItem(this.i18n.tr("Edit agent configuration"), this.imageEditConfig, () -> this.addMainView((View)new AgentConfigurationEditor((Node)object, object.getObjectId()), true, false));
            if (((Node)object).getPlatformName().startsWith("windows-")) {
                this.addObjectToolBarItem(this.i18n.tr("Take screenshot"), this.imageTakeScreenshot, () -> this.addMainView((View)new ScreenshotView((AbstractNode)((Node)object), null, null, 0L), true, false));
            }
        }
        if (object instanceof Node && ((Node)object).hasVNC()) {
            this.addObjectToolBarItem(this.i18n.tr("Remote control"), this.imageRemoteControl, () -> this.addMainView((View)new RemoteControlView((AbstractNode)((Node)object), 0L), true, false));
        }
        if (object instanceof Node && ((Node)object).hasSnmpAgent()) {
            this.addObjectToolBarItem(this.i18n.tr("&MIB Explorer"), this.imageOpenMibExplorer, () -> this.addMainView((View)new MibExplorer(object.getObjectId(), object.getObjectId()), true, false));
        }
        for (ObjectAction a : this.actionContributions) {
            if (!a.isValidForSelection((IStructuredSelection)this.selection)) continue;
            this.addObjectToolBarItem((Action)a);
        }
        this.addObjectToolBarItem(this.i18n.tr("Delete"), SharedIcons.IMG_DELETE_OBJECT, () -> {
            String question = String.format(this.i18n.tr("Are you sure you want to delete \"%s\"?"), object.getObjectName());
            if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)question)) {
                return;
            }
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        });
    }

    private void addObjectToolBarItem(String name, Image icon, Runnable handler) {
        ToolItem item = new ToolItem(this.objectToolBar, 8);
        item.setImage(icon);
        item.setToolTipText(name);
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addObjectToolBarItem(Action action) {
        ToolItem item = new ToolItem(this.objectToolBar, 8);
        Image icon = action.getImageDescriptor() != null ? action.getImageDescriptor().createImage() : ResourceManager.getImage((String)"icons/empty.png");
        item.setImage(icon);
        item.setToolTipText(action.getText());
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        item.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateObjectMenuBar(AbstractObject object) {
        for (ToolItem item : this.objectMenuBar.getItems()) {
            item.dispose();
        }
        this.addObjectMenu(this.i18n.tr("Tools"), ObjectMenuFactory.createToolsMenu((IStructuredSelection)new StructuredSelection((Object)object), (long)object.getObjectId(), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(this.i18n.tr("Graphs"), ObjectMenuFactory.createGraphTemplatesMenu((IStructuredSelection)new StructuredSelection((Object)object), (long)object.getObjectId(), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(this.i18n.tr("Summary Tables"), ObjectMenuFactory.createSummaryTableMenu((IStructuredSelection)new StructuredSelection((Object)object), (long)object.getObjectId(), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(this.i18n.tr("Poll"), ObjectMenuFactory.createPollMenu((IStructuredSelection)new StructuredSelection((Object)object), (long)object.getObjectId(), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(this.i18n.tr("Dashboards"), ObjectMenuFactory.createDashboardsMenu((IStructuredSelection)new StructuredSelection((Object)object), (long)object.getObjectId(), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(this.i18n.tr("Create"), (MenuManager)new ObjectCreateMenuManager(this.getWindow().getShell(), null, object));
        this.addObjectMenu(this.i18n.tr("Logs"), (MenuManager)new ObjectLogMenuManager(object, 0L, new ViewPlacement((Perspective)this)));
    }

    private void addObjectMenu(String name, Menu menu) {
        if (menu != null && menu.getItemCount() != 0) {
            this.createMenuToolItem(name, null, menu);
        }
    }

    private void addObjectMenu(String name, MenuManager menuManager) {
        if (menuManager != null && !menuManager.isEmpty()) {
            this.createMenuToolItem(name, menuManager, null);
        }
    }

    private void createMenuToolItem(String name, MenuManager menuManager, Menu menu) {
        ToolItem item = new ToolItem(this.objectMenuBar, 8);
        item.setText("  " + name + " \u25be  ");
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateContextDashboards(AbstractObject object) {
        if (!(object instanceof DataCollectionTarget || object instanceof Container || object instanceof Rack || object instanceof EntireNetwork || object instanceof ServiceRoot || object instanceof Subnet || object instanceof Zone || object instanceof Condition)) {
            return;
        }
        for (AbstractObject d : object.getDashboards(true)) {
            String viewId;
            if ((((Dashboard)d).getFlags() & 0x10000) == 0) {
                viewId = "ContextDashboard." + d.getObjectId();
                this.removeMainView(viewId);
                continue;
            }
            viewId = "ContextDashboard." + d.getObjectId();
            if (this.findMainView(viewId) != null) continue;
            this.addMainView((View)new ContextDashboardView((Dashboard)d));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public boolean showObject(AbstractObject object, long dciId) {
        if (!ObjectBrowser.calculateClassFilter((SubtreeType)this.subtreeType).contains(object.getObjectClass())) {
            return false;
        }
        Registry.getMainWindow().switchToPerspective(this.getId());
        if (!this.objectBrowser.selectObject(object)) {
            return false;
        }
        if (dciId != 0L && this.showMainView("DataCollection")) {
            View dataCollectionView = this.findMainView("DataCollection");
            ((DataCollectionView)dataCollectionView).selectDci(dciId);
        }
        return true;
    }

    private void openViewManager() {
        ArrayList<View> objectViews = new ArrayList<View>();
        for (View v : this.getAllMainViews()) {
            if (v.isCloseable() || !(v instanceof ObjectView)) continue;
            objectViews.add(v);
        }
        objectViews.sort((v1, v2) -> v1.getName().compareToIgnoreCase(v2.getName()));
        ObjectViewManagerDialog dlg = new ObjectViewManagerDialog(this.getWindow().getShell(), objectViews);
        if (dlg.open() == 0) {
            this.updateViewSet();
        }
    }

    public void saveState(Memento memento) {
        if (this.objectBrowser == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.objectBrowser.getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            memento.set("ObjectPerspective." + this.getId() + ".SelectedObject", ((AbstractObject)selection.getFirstElement()).getObjectId());
        }
    }

    public void restoreState(Memento memento) {
        NXCSession session;
        AbstractObject object;
        long id = memento.getAsLong("ObjectPerspective." + this.getId() + ".SelectedObject", 0L);
        if (id != 0L && (object = (session = Registry.getSession()).findObjectById(id, false)) != null) {
            this.objectBrowser.selectObject(object);
        }
    }

    static /* synthetic */ Object access$000(ObjectsPerspective x0) {
        return x0.getContext();
    }

    static /* synthetic */ void access$100(ObjectsPerspective x0) {
        x0.updateViewSet();
    }
}

