/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.ThresholdStateChange;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.ShowHistoricalDataMenuItems;
import org.netxms.nxmc.modules.datacollection.views.ThresholdSummaryView;
import org.netxms.nxmc.modules.datacollection.views.helpers.ThresholdTreeComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.ThresholdTreeContentProvider;
import org.netxms.nxmc.modules.datacollection.views.helpers.ThresholdTreeFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.ThresholdTreeLabelProvider;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ThresholdSummaryView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(ThresholdSummaryView.class);
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_STATUS = 1;
    public static final int COLUMN_PARAMETER = 2;
    public static final int COLUMN_VALUE = 3;
    public static final int COLUMN_CONDITION = 4;
    public static final int COLUMN_EVENT = 5;
    public static final int COLUMN_TIMESTAMP = 6;
    private SortableTreeViewer viewer;
    private SessionListener sessionListener = new /* Unavailable Anonymous Inner Class!! */;
    private boolean subscribed = false;
    private boolean refreshScheduled = false;

    public ThresholdSummaryView() {
        super(LocalizationHelper.getI18n(ThresholdSummaryView.class).tr("Thresholds"), ResourceManager.getImageDescriptor((String)"icons/object-views/thresholds.png"), "objects.threshold-summary", true);
    }

    public boolean isValidForContext(Object context) {
        return context instanceof EntireNetwork || context instanceof Zone || context instanceof Subnet || context instanceof ServiceRoot || context instanceof Container || context instanceof Rack || context instanceof Collector || context instanceof Cluster;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("Node"), this.i18n.tr("Status"), this.i18n.tr("Metric"), this.i18n.tr("Value"), this.i18n.tr("Condition"), this.i18n.tr("Event"), this.i18n.tr("Since")};
        int[] widths = new int[]{200, 100, 250, 100, 100, 250, 140};
        this.viewer = new SortableTreeViewer(parent, names, widths, 0, 128, 65536);
        this.viewer.setContentProvider((IContentProvider)new ThresholdTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ThresholdTreeLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ThresholdTreeComparator());
        ThresholdTreeFilter filter = new ThresholdTreeFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.createContextMenu();
        this.session.addListener(this.sessionListener);
    }

    private void processNotification(ThresholdStateChange stateChange) {
        AbstractObject object = this.getObject();
        if (this.refreshScheduled || object == null || object.getObjectId() != stateChange.getObjectId() && !object.isParentOf(stateChange.getObjectId())) {
            return;
        }
        this.refreshScheduled = true;
        this.getDisplay().timerExec(500, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public int getDciSelectionType() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return 0;
        }
        boolean isDci = false;
        boolean isTable = false;
        for (Object dcObject : selection.toList()) {
            if (dcObject instanceof DataCollectionTable || dcObject instanceof DciValue && ((DciValue)dcObject).getDcObjectType() == 2) {
                isTable = true;
                continue;
            }
            isDci = true;
        }
        return isTable & isDci ? 0 : (isTable ? 2 : 1);
    }

    private void fillContextMenu(IMenuManager mgr) {
        ShowHistoricalDataMenuItems.populateMenu((IMenuManager)mgr, (View)this, (AbstractObject)this.getObject(), (StructuredViewer)this.viewer, (int)this.getDciSelectionType());
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    protected void onObjectChange(AbstractObject object) {
        this.refresh();
    }

    public void refresh() {
        if (!this.isActive()) {
            return;
        }
        long rootId = this.getObjectId();
        if (rootId == 0L) {
            this.viewer.setInput((Object)new Object[0]);
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        if (this.subscribed) {
            5 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.setSystem(true);
            job.start();
        }
        super.dispose();
    }

    static /* synthetic */ NXCSession access$000(ThresholdSummaryView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(ThresholdSummaryView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(ThresholdSummaryView x0) {
        return x0.session;
    }
}

