/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.nxmc.base.widgets.TimePeriodCompactSelector;
import org.netxms.nxmc.base.widgets.TimePeriodSelector;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class TimePeriodCompactSelector
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(TimePeriodSelector.class);
    private static final TimePeriod[] PRESETS = new TimePeriod[]{new TimePeriod(TimeFrameType.BACK_FROM_NOW, 1, TimeUnit.HOUR, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 4, TimeUnit.HOUR, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 12, TimeUnit.HOUR, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 1, TimeUnit.DAY, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 7, TimeUnit.DAY, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 30, TimeUnit.DAY, null, null), new TimePeriod(TimeFrameType.BACK_FROM_NOW, 90, TimeUnit.DAY, null, null)};
    private TimePeriod timePeriod;
    private Button description;
    private Shell selectorShell;
    private Set<SelectionListener> selectionListeners = new HashSet();

    public TimePeriodCompactSelector(Composite parent, int style) {
        this(parent, style, new TimePeriod(TimeFrameType.BACK_FROM_NOW, 1, TimeUnit.HOUR, null, null));
    }

    public TimePeriodCompactSelector(Composite parent, int style, TimePeriod initialTimePeriod) {
        super(parent, style);
        this.timePeriod = initialTimePeriod;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.description = new Button((Composite)this, 0x800008);
        this.description.setLayoutData((Object)new GridData(4, 4, true, false));
        this.description.setCursor(this.getDisplay().getSystemCursor(21));
        this.description.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.updateDescription();
    }

    private void showSelector() {
        this.selectorShell = new Shell(this.getShell(), 8);
        this.selectorShell.setLayout((Layout)new FillLayout());
        this.selectorShell.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite content = new Composite((Composite)this.selectorShell, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        content.setLayout((Layout)layout);
        Label presetsLabel = new Label(content, 0);
        presetsLabel.setText(this.i18n.tr("Presets"));
        TimePeriodSelector selector = new TimePeriodSelector(content, 512, this.timePeriod);
        selector.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        List presetList = new List(content, 67584);
        GridData gd = new GridData();
        gd.widthHint = 200;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        presetList.setLayoutData((Object)gd);
        for (TimePeriod p : PRESETS) {
            presetList.add(this.describeTimePeriod(p));
        }
        presetList.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        presetList.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonBar = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        buttonBar.setLayout((Layout)layout);
        gd = new GridData(131072, 4, true, false, 2, 1);
        gd.verticalIndent = 6;
        buttonBar.setLayoutData((Object)gd);
        Button buttonApply = new Button(buttonBar, -1);
        Button buttonCancel = new Button(buttonBar, 8);
        this.selectorShell.setDefaultButton(buttonApply);
        buttonApply.setText(this.i18n.tr("&Apply"));
        gd = new GridData();
        gd.widthHint = 90;
        buttonApply.setLayoutData((Object)gd);
        buttonApply.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonCancel.setText(this.i18n.tr("Cancel"));
        gd = new GridData();
        gd.widthHint = 90;
        buttonCancel.setLayoutData((Object)gd);
        buttonCancel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectorShell.pack();
        Point shellSize = this.selectorShell.getSize();
        Rectangle displayBounds = this.getDisplay().getBounds();
        Point l = this.getLocation();
        l.y += this.getSize().y + 1;
        l = this.getDisplay().map((Control)this.getParent(), null, l);
        if (l.x + shellSize.x >= displayBounds.width) {
            l.x = displayBounds.width - shellSize.x - 1;
        }
        if (l.y + shellSize.y >= displayBounds.height) {
            l.y = displayBounds.height - shellSize.y - 1;
        }
        this.selectorShell.setLocation(l);
        this.updateDescription();
        this.selectorShell.open();
    }

    private void updateDescription() {
        if (this.description.isDisposed()) {
            return;
        }
        this.description.setText(this.describeTimePeriod(this.timePeriod) + (this.selectorShell != null ? "  \u25b4" : "  \u25be"));
        this.getParent().layout();
    }

    private String describeTimePeriod(TimePeriod p) {
        StringBuilder sb = new StringBuilder();
        if (p.isBackFromNow()) {
            sb.append(this.i18n.tr("Last "));
            if (p.getTimeRange() == 1) {
                switch (7.$SwitchMap$org$netxms$client$constants$TimeUnit[p.getTimeUnit().ordinal()]) {
                    case 1: {
                        sb.append(this.i18n.tr("day"));
                        break;
                    }
                    case 2: {
                        sb.append(this.i18n.tr("hour"));
                        break;
                    }
                    case 3: {
                        sb.append(this.i18n.tr("minute"));
                    }
                }
            } else if (p.getTimeRange() == 7 && p.getTimeUnit() == TimeUnit.DAY) {
                sb.append(this.i18n.tr(" week"));
            } else {
                sb.append(p.getTimeRange());
                switch (7.$SwitchMap$org$netxms$client$constants$TimeUnit[p.getTimeUnit().ordinal()]) {
                    case 1: {
                        sb.append(this.i18n.tr(" days"));
                        break;
                    }
                    case 2: {
                        sb.append(this.i18n.tr(" hours"));
                        break;
                    }
                    case 3: {
                        sb.append(this.i18n.tr(" minutes"));
                    }
                }
            }
        } else {
            sb.append(DateFormatFactory.getDateTimeFormat().format(p.getPeriodStart()));
            sb.append(" \u2013 ");
            sb.append(DateFormatFactory.getDateTimeFormat().format(p.getPeriodEnd()));
        }
        return sb.toString();
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        this.updateDescription();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void fireSelectionListeners() {
        Event e = new Event();
        e.display = this.getDisplay();
        e.doit = true;
        e.widget = this;
        SelectionEvent se = new SelectionEvent(e);
        for (SelectionListener l : this.selectionListeners) {
            l.widgetSelected(se);
        }
    }
}

