/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.tools.WidgetHelper;

public class MarkdownViewer
extends Composite {
    private Browser browser;
    private String text = "";
    private int htmlDocumentHeight = 0;
    private Runnable renderCompletionHandler = null;
    private String htmlHeader;

    public MarkdownViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.browser = WidgetHelper.createBrowser((Composite)this, (int)0, null);
        this.browser.addProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
        FontData f = JFaceResources.getDefaultFont().getFontData()[0];
        this.htmlHeader = "<html><head><style>body { font-family: " + f.getName() + "; font-size: " + f.getHeight() + "px; font-weight: normal; margin: 0; padding: 0; }</style></head><body><div class=\"content\" style=\"padding-left: 5px; padding-right: 5px;\">";
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint != -1) {
            return super.computeSize(wHint, hHint, changed);
        }
        return new Point(wHint == -1 ? 100 : wHint, this.htmlDocumentHeight);
    }

    public void setText(String text) {
        this.htmlDocumentHeight = 0;
        this.text = text != null ? text : "";
        Parser parser = Parser.builder().build();
        Node document = parser.parse(this.text);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        String html = this.htmlHeader + renderer.render(document) + "</div></body></html>";
        this.browser.setText(html);
    }

    public String getText() {
        return this.text;
    }

    public Runnable getRenderCompletionHandler() {
        return this.renderCompletionHandler;
    }

    public void setRenderCompletionHandler(Runnable renderCompletionHandler) {
        this.renderCompletionHandler = renderCompletionHandler;
    }
}

