/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.helpers.ExecutorListLabelProvider;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.ui.eclipse.objecttools.widgets.ActionExecutor;
import org.netxms.ui.eclipse.objecttools.widgets.LocalCommandExecutor;
import org.netxms.ui.eclipse.objecttools.widgets.SSHExecutor;
import org.netxms.ui.eclipse.objecttools.widgets.ServerCommandExecutor;
import org.netxms.ui.eclipse.objecttools.widgets.ServerScriptExecutor;
import org.netxms.ui.eclipse.objecttools.widgets.helpers.ExecutorStateChangeListener;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class MultiNodeCommandExecutor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.MultiNodeCommandExecutor";
    private SashForm splitter;
    private SortableTableViewer viewer;
    private Composite resultArea;
    private List<AbstractObjectToolExecutor> executors = new ArrayList<AbstractObjectToolExecutor>();
    private AbstractObjectToolExecutor currentExecutor = null;
    private AbstractObjectToolExecutor.ActionSet actions;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.splitter = new SashForm(parent, 512);
        Composite topPart = new Composite((Composite)this.splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        topPart.setLayout((Layout)layout);
        String[] names = new String[]{"Name", "Status"};
        int[] widths = new int[]{600, 200};
        this.viewer = new SortableTableViewer(topPart, names, widths, 0, 1024, 65536);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExecutorListLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                AbstractObjectToolExecutor s1 = (AbstractObjectToolExecutor)((Object)e1);
                AbstractObjectToolExecutor s2 = (AbstractObjectToolExecutor)((Object)e2);
                int result = s1.getObject().getObjectName().compareToIgnoreCase(s2.getObject().getObjectName());
                return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MultiNodeCommandExecutor.this.onSelectionChange();
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(topPart, 258).setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite bottomPart = new Composite((Composite)this.splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        bottomPart.setLayout((Layout)layout);
        new Label(bottomPart, 258).setLayoutData((Object)new GridData(4, 1024, true, false));
        this.resultArea = new Composite(bottomPart, 0);
        this.resultArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = MultiNodeCommandExecutor.this.resultArea.getClientArea();
                Control[] controlArray = MultiNodeCommandExecutor.this.resultArea.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setSize(clientArea.width, clientArea.height);
                    ++n2;
                }
            }
        });
        this.createActions();
        this.activateContext();
    }

    protected void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actions = new AbstractObjectToolExecutor.ActionSet();
        Messages.get();
        this.actions.actionClear = new Action(Messages.LocalCommandResults_ClearConsole, SharedIcons.CLEAR_LOG){

            public void run() {
                if (MultiNodeCommandExecutor.this.currentExecutor != null) {
                    MultiNodeCommandExecutor.this.currentExecutor.clearOutput();
                }
            }
        };
        this.actions.actionClear.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.clear_output");
        handlerService.activateHandler(this.actions.actionClear.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actions.actionClear));
        Messages.get();
        this.actions.actionScrollLock = new Action(Messages.LocalCommandResults_ScrollLock, 2){

            public void run() {
                if (MultiNodeCommandExecutor.this.currentExecutor != null) {
                    MultiNodeCommandExecutor.this.currentExecutor.setAutoScroll(!MultiNodeCommandExecutor.this.actions.actionScrollLock.isChecked());
                }
            }
        };
        this.actions.actionScrollLock.setImageDescriptor(Activator.getImageDescriptor("icons/scroll_lock.gif"));
        this.actions.actionScrollLock.setChecked(false);
        this.actions.actionScrollLock.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.scroll_lock");
        handlerService.activateHandler(this.actions.actionScrollLock.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actions.actionScrollLock));
        Messages.get();
        this.actions.actionCopy = new Action(Messages.LocalCommandResults_Copy){

            public void run() {
                if (MultiNodeCommandExecutor.this.currentExecutor != null) {
                    MultiNodeCommandExecutor.this.currentExecutor.copyOutput();
                }
            }
        };
        this.actions.actionCopy.setEnabled(false);
        this.actions.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.copy");
        handlerService.activateHandler(this.actions.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actions.actionCopy));
        Messages.get();
        this.actions.actionSelectAll = new Action(Messages.LocalCommandResults_SelectAll){

            public void run() {
                if (MultiNodeCommandExecutor.this.currentExecutor != null) {
                    MultiNodeCommandExecutor.this.currentExecutor.selectAll();
                }
            }
        };
        this.actions.actionSelectAll.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.select_all");
        handlerService.activateHandler(this.actions.actionSelectAll.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actions.actionSelectAll));
        Messages.get();
        this.actions.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                if (MultiNodeCommandExecutor.this.currentExecutor != null) {
                    MultiNodeCommandExecutor.this.currentExecutor.execute();
                }
            }
        };
        this.actions.actionRestart.setEnabled(false);
        Messages.get();
        this.actions.actionTerminate = new Action(Messages.LocalCommandResults_Terminate, SharedIcons.TERMINATE){

            public void run() {
                if (MultiNodeCommandExecutor.this.currentExecutor != null) {
                    MultiNodeCommandExecutor.this.currentExecutor.terminate();
                }
            }
        };
        this.actions.actionTerminate.setEnabled(false);
        this.actions.actionTerminate.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.terminate_process");
        handlerService.activateHandler(this.actions.actionTerminate.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actions.actionTerminate));
    }

    private void onSelectionChange() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection == null) {
            return;
        }
        AbstractObjectToolExecutor executor = (AbstractObjectToolExecutor)((Object)selection.getFirstElement());
        if (this.currentExecutor != executor) {
            if (this.currentExecutor != null) {
                this.currentExecutor.hide();
            }
            this.currentExecutor = executor;
            if (this.currentExecutor != null) {
                this.currentExecutor.show();
            }
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objecttools.context.ObjectTools");
        }
    }

    public void execute(ObjectTool tool, Set<ObjectContext> nodes, Map<String, String> inputValues, List<String> maskedFields, List<String> expandedText) {
        this.setPartName(tool.getDisplayName());
        this.executors.clear();
        int i = 0;
        for (ObjectContext ctx : nodes) {
            AbstractObjectToolExecutor executor;
            switch (tool.getToolType()) {
                case 1: {
                    executor = new ActionExecutor(this.resultArea, this, ctx, this.actions, tool, inputValues, maskedFields);
                    break;
                }
                case 5: {
                    executor = new LocalCommandExecutor(this.resultArea, this, ctx, this.actions, tool, expandedText.get(i++));
                    break;
                }
                case 6: {
                    executor = new ServerCommandExecutor(this.resultArea, this, ctx, this.actions, tool, inputValues, maskedFields);
                    break;
                }
                case 10: {
                    executor = new SSHExecutor(this.resultArea, this, ctx, this.actions, tool, inputValues, maskedFields);
                    break;
                }
                case 8: {
                    executor = new ServerScriptExecutor(this.resultArea, this, ctx, this.actions, tool, inputValues, maskedFields);
                    break;
                }
                default: {
                    executor = null;
                }
            }
            executor.addStateChangeListener(new ExecutorStateChangeListener(){

                @Override
                public void runningStateChanged(boolean running) {
                    MultiNodeCommandExecutor.this.viewer.update((Object)executor, null);
                }
            });
            this.executors.add(executor);
            executor.execute();
        }
        this.viewer.setInput((Object)this.executors.toArray());
        this.viewer.getTable().setSelection(0);
        this.onSelectionChange();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }
}

