/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.compatibility.GraphItem;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AvailabilityChartConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.DateBuilder;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class AvailabilityChartElement
extends ElementWidget {
    private AvailabilityChartConfig elementConfig;
    private Chart chart;
    private NXCSession session = ConsoleSharedData.getSession();
    private ViewRefreshController refreshController;

    public AvailabilityChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AvailabilityChartElement.this.refreshController != null) {
                    AvailabilityChartElement.this.refreshController.dispose();
                }
            }
        });
        try {
            this.elementConfig = (AvailabilityChartConfig)XMLTools.createFromXml(AvailabilityChartConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elementConfig = new AvailabilityChartConfig();
        }
        this.processCommonSettings(this.elementConfig);
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.PIE, chartConfig);
        this.chart.addParameter(new GraphItem("Uptime", "Uptime", null));
        this.chart.addParameter(new GraphItem("Downtime", "Downtime", null));
        this.chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        this.chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        this.chart.rebuild();
        if ((this.elementConfig.getPeriod() & 1) == 0) {
            this.refreshController = new ViewRefreshController(viewPart, 60, new Runnable(){

                @Override
                public void run() {
                    if (AvailabilityChartElement.this.isDisposed()) {
                        return;
                    }
                    AvailabilityChartElement.this.refreshData();
                }
            });
        }
        this.refreshData();
    }

    private void refreshData() {
        final TimePeriod timePeriod = AvailabilityChartElement.buildTimePeriod(this.elementConfig.getPeriod(), this.elementConfig.getNumberOfDays());
        ConsoleJob availabilityJob = new ConsoleJob("Get business service availability", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final double availability = AvailabilityChartElement.this.session.getBusinessServiceAvailablity(AvailabilityChartElement.this.elementConfig.getObjectId(), timePeriod);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).AvailabilityChartElement.this.chart.updateParameter(0, availability, false);
                        (this).AvailabilityChartElement.this.chart.updateParameter(1, 100.0 - availability, true);
                        (this).AvailabilityChartElement.this.chart.clearErrors();
                        if (((this).AvailabilityChartElement.this.elementConfig.getPeriod() & 1) != 0) {
                            Date refreshTime = new DateBuilder().add(5, 1).setMidnight().add(12, 1).create();
                            this.getDisplay().timerExec((int)(refreshTime.getTime() - System.currentTimeMillis()), new Runnable(){

                                @Override
                                public void run() {
                                    if (!AvailabilityChartElement.this.isDisposed()) {
                                        AvailabilityChartElement.this.refreshData();
                                    }
                                }
                            });
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot get availability for business service %s", AvailabilityChartElement.this.session.getObjectName(AvailabilityChartElement.this.elementConfig.getObjectId()));
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).AvailabilityChartElement.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        availabilityJob.setUser(false);
        availabilityJob.start();
    }

    private static TimePeriod buildTimePeriod(int periodType, int numberOfDays) {
        switch (periodType) {
            case 8: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(5, 1 - numberOfDays).setMidnight().create(), new Date());
            }
            case 5: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(2, -1).set(5, 1).setMidnight().create(), new DateBuilder().add(2, -1).setLastDayOfMonth().setMidnight().add(13, 86399).create());
            }
            case 3: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(3, -1).set(7, 2).setMidnight().create(), new DateBuilder().set(7, 2).setMidnight().add(13, -1).create());
            }
            case 7: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(1, -1).set(6, 1).setMidnight().create(), new DateBuilder().set(6, 1).setMidnight().add(13, -1).create());
            }
            case 4: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().set(5, 1).setMidnight().create(), new Date());
            }
            case 2: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().set(7, 2).setMidnight().create(), new Date());
            }
            case 6: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().set(6, 1).setMidnight().create(), new Date());
            }
            case 0: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().setMidnight().create(), new Date());
            }
            case 1: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().setMidnight().add(5, -1).create(), new DateBuilder().setMidnight().add(13, -1).create());
            }
        }
        return null;
    }
}

